/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableStateManager;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.junit.Assert;

public class MasterProcedureTestingUtility {
    private static final Log LOG = LogFactory.getLog(MasterProcedureTestingUtility.class);

    private MasterProcedureTestingUtility() {
    }

    public static HTableDescriptor createHTD(TableName tableName, String ... family) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (int i = 0; i < family.length; ++i) {
            htd.addFamily(new HColumnDescriptor(family[i]));
        }
        return htd;
    }

    public static HRegionInfo[] createTable(ProcedureExecutor<MasterProcedureEnv> procExec, TableName tableName, byte[][] splitKeys, String ... family) throws IOException {
        HTableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, family);
        HRegionInfo[] regions = ModifyRegionUtils.createHRegionInfos((HTableDescriptor)htd, (byte[][])splitKeys);
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions));
        ProcedureTestingUtility.assertProcNotFailed((ProcedureInfo)procExec.getResult(procId));
        return regions;
    }

    public static void validateTableCreation(HMaster master, TableName tableName, HRegionInfo[] regions, String ... family) throws IOException {
        MasterProcedureTestingUtility.validateTableCreation(master, tableName, regions, true, family);
    }

    public static void validateTableCreation(HMaster master, TableName tableName, HRegionInfo[] regions, boolean hasFamilyDirs, String ... family) throws IOException {
        FileSystem fs = master.getMasterFileSystem().getFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)master.getMasterFileSystem().getRootDir(), (TableName)tableName);
        Assert.assertTrue((boolean)fs.exists(tableDir));
        FSUtils.logFileSystemState((FileSystem)fs, (Path)tableDir, (Log)LOG);
        List allRegionDirs = FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir);
        for (int i = 0; i < regions.length; ++i) {
            Path regionDir = new Path(tableDir, regions[i].getEncodedName());
            Assert.assertTrue((String)(regions[i] + " region dir does not exist"), (boolean)fs.exists(regionDir));
            Assert.assertTrue((boolean)allRegionDirs.remove(regionDir));
            List allFamilyDirs = FSUtils.getFamilyDirs((FileSystem)fs, (Path)regionDir);
            for (int j = 0; j < family.length; ++j) {
                Path familyDir = new Path(regionDir, family[j]);
                if (hasFamilyDirs) {
                    Assert.assertTrue((String)(family[j] + " family dir does not exist"), (boolean)fs.exists(familyDir));
                    Assert.assertTrue((boolean)allFamilyDirs.remove(familyDir));
                    continue;
                }
                if (!fs.exists(familyDir)) {
                    LOG.warn((Object)(family[j] + " family dir does not exist"));
                }
                allFamilyDirs.remove(familyDir);
            }
            Assert.assertTrue((String)("found extraneous families: " + allFamilyDirs), (boolean)allFamilyDirs.isEmpty());
        }
        Assert.assertTrue((String)("found extraneous regions: " + allRegionDirs), (boolean)allRegionDirs.isEmpty());
        Assert.assertTrue((boolean)MetaTableAccessor.tableExists((Connection)master.getConnection(), (TableName)tableName));
        Assert.assertEquals((long)regions.length, (long)MasterProcedureTestingUtility.countMetaRegions(master, tableName));
        HTableDescriptor htd = master.getTableDescriptors().get(tableName);
        Assert.assertTrue((String)"table descriptor not found", (htd != null ? 1 : 0) != 0);
        for (int i = 0; i < family.length; ++i) {
            Assert.assertTrue((String)("family not found " + family[i]), (htd.getFamily(Bytes.toBytes((String)family[i])) != null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)family.length, (long)htd.getFamilies().size());
    }

    public static void validateTableDeletion(HMaster master, TableName tableName, HRegionInfo[] regions, String ... family) throws IOException {
        FileSystem fs = master.getMasterFileSystem().getFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)master.getMasterFileSystem().getRootDir(), (TableName)tableName);
        Assert.assertFalse((boolean)fs.exists(tableDir));
        Assert.assertFalse((boolean)MetaTableAccessor.tableExists((Connection)master.getConnection(), (TableName)tableName));
        Assert.assertEquals((long)0L, (long)MasterProcedureTestingUtility.countMetaRegions(master, tableName));
        Assert.assertTrue((String)"found htd of deleted table", (master.getTableDescriptors().get(tableName) == null ? 1 : 0) != 0);
    }

    private static int countMetaRegions(HMaster master, final TableName tableName) throws IOException {
        final AtomicInteger actualRegCount = new AtomicInteger(0);
        MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

            public boolean processRow(Result rowResult) throws IOException {
                HRegionLocation[] locations;
                RegionLocations list = MetaTableAccessor.getRegionLocations((Result)rowResult);
                if (list == null) {
                    LOG.warn((Object)("No serialized HRegionInfo in " + rowResult));
                    return true;
                }
                HRegionLocation l = list.getRegionLocation();
                if (l == null) {
                    return true;
                }
                if (!l.getRegionInfo().getTable().equals((Object)tableName)) {
                    return false;
                }
                if (l.getRegionInfo().isOffline() || l.getRegionInfo().isSplit()) {
                    return true;
                }
                for (HRegionLocation location : locations = list.getRegionLocations()) {
                    ServerName serverName;
                    if (location == null || (serverName = location.getServerName()) == null || serverName.getHostAndPort() == null) continue;
                    actualRegCount.incrementAndGet();
                }
                return true;
            }
        };
        MetaScanner.metaScan((Connection)master.getConnection(), (MetaScanner.MetaScannerVisitor)visitor, (TableName)tableName);
        return actualRegCount.get();
    }

    public static void validateTableIsEnabled(HMaster master, TableName tableName) throws IOException {
        TableStateManager tsm = master.getAssignmentManager().getTableStateManager();
        Assert.assertTrue((boolean)tsm.isTableState(tableName, new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.ENABLED}));
    }

    public static void validateTableIsDisabled(HMaster master, TableName tableName) throws IOException {
        TableStateManager tsm = master.getAssignmentManager().getTableStateManager();
        Assert.assertTrue((boolean)tsm.isTableState(tableName, new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.DISABLED}));
    }

    public static <TState> void testRecoveryAndDoubleExecution(ProcedureExecutor<MasterProcedureEnv> procExec, long procId, int numSteps, TState[] states) throws Exception {
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Assert.assertEquals((Object)false, (Object)procExec.isRunning());
        for (int i = 0; i < numSteps; ++i) {
            LOG.info((Object)("Restart " + i + " exec state: " + states[i]));
            ProcedureTestingUtility.assertProcNotYetCompleted(procExec, (long)procId);
            ProcedureTestingUtility.restart(procExec);
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        }
        Assert.assertEquals((Object)true, (Object)procExec.isRunning());
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }

    public static <TState> void testRecoveryAndDoubleExecution(ProcedureExecutor<MasterProcedureEnv> procExec, long procId) throws Exception {
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Assert.assertEquals((Object)false, (Object)procExec.isRunning());
        while (!procExec.isFinished(procId)) {
            ProcedureTestingUtility.restart(procExec);
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        }
        Assert.assertEquals((Object)true, (Object)procExec.isRunning());
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TState> void testRollbackAndDoubleExecution(ProcedureExecutor<MasterProcedureEnv> procExec, long procId, int lastStep, TState[] states) throws Exception {
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        for (int i = 0; i < lastStep; ++i) {
            LOG.info((Object)("Restart " + i + " exec state: " + states[i]));
            ProcedureTestingUtility.assertProcNotYetCompleted(procExec, (long)procId);
            ProcedureTestingUtility.restart(procExec);
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        }
        InjectAbortOnLoadListener abortListener = new InjectAbortOnLoadListener(procExec);
        procExec.registerListener((ProcedureExecutor.ProcedureExecutorListener)abortListener);
        try {
            for (int i = lastStep + 1; i >= 0; --i) {
                LOG.info((Object)("Restart " + i + " rollback state: " + states[i]));
                ProcedureTestingUtility.assertProcNotYetCompleted(procExec, (long)procId);
                ProcedureTestingUtility.restart(procExec);
                ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
            }
        }
        finally {
            Assert.assertTrue((boolean)procExec.unregisterListener((ProcedureExecutor.ProcedureExecutorListener)abortListener));
        }
        ProcedureTestingUtility.assertIsAbortException((ProcedureInfo)procExec.getResult(procId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TState> void testRollbackAndDoubleExecutionAfterPONR(ProcedureExecutor<MasterProcedureEnv> procExec, long procId, int lastStep, TState[] states) throws Exception {
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        for (int i = 0; i < lastStep; ++i) {
            LOG.info((Object)("Restart " + i + " exec state: " + states[i]));
            ProcedureTestingUtility.assertProcNotYetCompleted(procExec, (long)procId);
            ProcedureTestingUtility.restart(procExec);
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        }
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        InjectAbortOnLoadListener abortListener = new InjectAbortOnLoadListener(procExec);
        procExec.registerListener((ProcedureExecutor.ProcedureExecutorListener)abortListener);
        try {
            ProcedureTestingUtility.assertProcNotYetCompleted(procExec, (long)procId);
            ProcedureTestingUtility.restart(procExec);
            LOG.info((Object)"Restart and execute");
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        }
        finally {
            Assert.assertTrue((boolean)procExec.unregisterListener((ProcedureExecutor.ProcedureExecutorListener)abortListener));
        }
        Assert.assertEquals((Object)true, (Object)procExec.isRunning());
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TState> void testRollbackRetriableFailure(ProcedureExecutor<MasterProcedureEnv> procExec, long procId, int lastStep, TState[] states) throws Exception {
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        for (int i = 0; i < lastStep; ++i) {
            LOG.info((Object)("Restart " + i + " exec state: " + states[i]));
            ProcedureTestingUtility.assertProcNotYetCompleted(procExec, (long)procId);
            ProcedureTestingUtility.restart(procExec);
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        }
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        InjectAbortOnLoadListener abortListener = new InjectAbortOnLoadListener(procExec);
        procExec.registerListener((ProcedureExecutor.ProcedureExecutorListener)abortListener);
        try {
            ProcedureTestingUtility.assertProcNotYetCompleted(procExec, (long)procId);
            ProcedureTestingUtility.restart(procExec);
            LOG.info((Object)"Restart and rollback");
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        }
        finally {
            Assert.assertTrue((boolean)procExec.unregisterListener((ProcedureExecutor.ProcedureExecutorListener)abortListener));
        }
        ProcedureTestingUtility.assertIsAbortException((ProcedureInfo)procExec.getResult(procId));
    }

    public static void validateColumnFamilyAddition(HMaster master, TableName tableName, String family) throws IOException {
        HTableDescriptor htd = master.getTableDescriptors().get(tableName);
        Assert.assertTrue((htd != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)htd.hasFamily(family.getBytes()));
    }

    public static void validateColumnFamilyDeletion(HMaster master, TableName tableName, String family) throws IOException {
        HTableDescriptor htd = master.getTableDescriptors().get(tableName);
        Assert.assertTrue((htd != null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)htd.hasFamily(family.getBytes()));
        FileSystem fs = master.getMasterFileSystem().getFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)master.getMasterFileSystem().getRootDir(), (TableName)tableName);
        for (Path regionDir : FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir)) {
            Path familyDir = new Path(regionDir, family);
            Assert.assertFalse((String)(family + " family dir should not exist"), (boolean)fs.exists(familyDir));
        }
    }

    public static void validateColumnFamilyModification(HMaster master, TableName tableName, String family, HColumnDescriptor columnDescriptor) throws IOException {
        HTableDescriptor htd = master.getTableDescriptors().get(tableName);
        Assert.assertTrue((htd != null ? 1 : 0) != 0);
        HColumnDescriptor hcfd = htd.getFamily(family.getBytes());
        Assert.assertTrue((boolean)hcfd.equals((Object)columnDescriptor));
    }

    public static void loadData(Connection connection, TableName tableName, int rows, byte[][] splitKeys, String ... sfamilies) throws IOException {
        byte[][] families = new byte[sfamilies.length][];
        for (int i = 0; i < families.length; ++i) {
            families[i] = Bytes.toBytes((String)sfamilies[i]);
        }
        BufferedMutator mutator = connection.getBufferedMutator(tableName);
        Assert.assertTrue((rows >= splitKeys.length ? 1 : 0) != 0);
        for (byte[] k : splitKeys) {
            byte[] value = Bytes.add((byte[])Bytes.toBytes((long)System.currentTimeMillis()), (byte[])k);
            byte[] key = Bytes.add((byte[])k, (byte[])Bytes.toBytes((String)MD5Hash.getMD5AsHex((byte[])value)));
            mutator.mutate((Mutation)MasterProcedureTestingUtility.createPut(families, key, value));
            --rows;
        }
        while (rows-- > 0) {
            byte[] value = Bytes.add((byte[])Bytes.toBytes((long)System.currentTimeMillis()), (byte[])Bytes.toBytes((int)rows));
            byte[] key = Bytes.toBytes((String)MD5Hash.getMD5AsHex((byte[])value));
            mutator.mutate((Mutation)MasterProcedureTestingUtility.createPut(families, key, value));
        }
        mutator.flush();
    }

    private static Put createPut(byte[][] families, byte[] key, byte[] value) {
        byte[] q = Bytes.toBytes((String)"q");
        Put put = new Put(key);
        put.setDurability(Durability.SKIP_WAL);
        for (byte[] family : families) {
            put.add(family, q, value);
        }
        return put;
    }

    public static long generateNonceGroup(HMaster master) {
        return master.getConnection().getNonceGenerator().getNonceGroup();
    }

    public static long generateNonce(HMaster master) {
        return master.getConnection().getNonceGenerator().newNonce();
    }

    public static class InjectAbortOnLoadListener
    implements ProcedureExecutor.ProcedureExecutorListener {
        private final ProcedureExecutor<MasterProcedureEnv> procExec;

        public InjectAbortOnLoadListener(ProcedureExecutor<MasterProcedureEnv> procExec) {
            this.procExec = procExec;
        }

        public void procedureLoaded(long procId) {
            this.procExec.abort(procId);
        }

        public void procedureAdded(long procId) {
        }

        public void procedureFinished(long procId) {
        }
    }
}

