/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.NoopQuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaScope;
import org.apache.hadoop.hbase.quotas.QuotaState;
import org.apache.hadoop.hbase.quotas.ThrottlingException;
import org.apache.hadoop.hbase.quotas.UserQuotaState;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestQuotaState {
    private static final TableName UNKNOWN_TABLE_NAME = TableName.valueOf((String)"unknownTable");

    @Test(timeout=60000L)
    public void testQuotaStateBypass() {
        QuotaState quotaInfo = new QuotaState();
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        this.assertNoopLimiter(quotaInfo.getGlobalLimiter());
        UserQuotaState userQuotaState = new UserQuotaState();
        Assert.assertTrue((boolean)userQuotaState.isBypass());
        this.assertNoopLimiter(userQuotaState.getTableLimiter(UNKNOWN_TABLE_NAME));
    }

    @Test(timeout=60000L)
    public void testSimpleQuotaStateOperation() {
        TableName table = TableName.valueOf((String)"testSimpleQuotaStateOperationTable");
        int NUM_GLOBAL_THROTTLE = 3;
        int NUM_TABLE_THROTTLE = 2;
        UserQuotaState quotaInfo = new UserQuotaState();
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        quotaInfo.setQuotas(this.buildReqNumThrottle(3L));
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        quotaInfo.setQuotas(table, this.buildReqNumThrottle(2L));
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        Assert.assertTrue((quotaInfo.getGlobalLimiter() == quotaInfo.getTableLimiter(UNKNOWN_TABLE_NAME) ? 1 : 0) != 0);
        this.assertThrottleException(quotaInfo.getTableLimiter(UNKNOWN_TABLE_NAME), 3);
        this.assertThrottleException(quotaInfo.getTableLimiter(table), 2);
    }

    @Test(timeout=60000L)
    public void testQuotaStateUpdateBypassThrottle() {
        long LAST_UPDATE = 10L;
        UserQuotaState quotaInfo = new UserQuotaState();
        Assert.assertEquals((long)0L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        UserQuotaState otherQuotaState = new UserQuotaState(10L);
        Assert.assertEquals((long)10L, (long)otherQuotaState.getLastUpdate());
        Assert.assertTrue((boolean)otherQuotaState.isBypass());
        quotaInfo.update((QuotaState)otherQuotaState);
        Assert.assertEquals((long)10L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        Assert.assertTrue((quotaInfo.getGlobalLimiter() == quotaInfo.getTableLimiter(UNKNOWN_TABLE_NAME) ? 1 : 0) != 0);
        this.assertNoopLimiter(quotaInfo.getTableLimiter(UNKNOWN_TABLE_NAME));
    }

    @Test(timeout=60000L)
    public void testQuotaStateUpdateGlobalThrottle() {
        int NUM_GLOBAL_THROTTLE_1 = 3;
        int NUM_GLOBAL_THROTTLE_2 = 11;
        long LAST_UPDATE_1 = 10L;
        long LAST_UPDATE_2 = 20L;
        long LAST_UPDATE_3 = 30L;
        QuotaState quotaInfo = new QuotaState();
        Assert.assertEquals((long)0L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        QuotaState otherQuotaState = new QuotaState(10L);
        otherQuotaState.setQuotas(this.buildReqNumThrottle(3L));
        Assert.assertEquals((long)10L, (long)otherQuotaState.getLastUpdate());
        Assert.assertFalse((boolean)otherQuotaState.isBypass());
        quotaInfo.update(otherQuotaState);
        Assert.assertEquals((long)10L, (long)quotaInfo.getLastUpdate());
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        this.assertThrottleException(quotaInfo.getGlobalLimiter(), 3);
        otherQuotaState = new QuotaState(20L);
        otherQuotaState.setQuotas(this.buildReqNumThrottle(11L));
        Assert.assertEquals((long)20L, (long)otherQuotaState.getLastUpdate());
        Assert.assertFalse((boolean)otherQuotaState.isBypass());
        quotaInfo.update(otherQuotaState);
        Assert.assertEquals((long)20L, (long)quotaInfo.getLastUpdate());
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        this.assertThrottleException(quotaInfo.getGlobalLimiter(), 8);
        otherQuotaState = new QuotaState(30L);
        Assert.assertEquals((long)30L, (long)otherQuotaState.getLastUpdate());
        Assert.assertTrue((boolean)otherQuotaState.isBypass());
        quotaInfo.update(otherQuotaState);
        Assert.assertEquals((long)30L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        this.assertNoopLimiter(quotaInfo.getGlobalLimiter());
    }

    @Test(timeout=60000L)
    public void testQuotaStateUpdateTableThrottle() {
        TableName TABLE_A = TableName.valueOf((String)"TableA");
        TableName TABLE_B = TableName.valueOf((String)"TableB");
        TableName TABLE_C = TableName.valueOf((String)"TableC");
        int TABLE_A_THROTTLE_1 = 3;
        int TABLE_A_THROTTLE_2 = 11;
        int TABLE_B_THROTTLE = 4;
        int TABLE_C_THROTTLE = 5;
        long LAST_UPDATE_1 = 10L;
        long LAST_UPDATE_2 = 20L;
        long LAST_UPDATE_3 = 30L;
        UserQuotaState quotaInfo = new UserQuotaState();
        Assert.assertEquals((long)0L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        UserQuotaState otherQuotaState = new UserQuotaState(10L);
        otherQuotaState.setQuotas(TABLE_A, this.buildReqNumThrottle(3L));
        otherQuotaState.setQuotas(TABLE_B, this.buildReqNumThrottle(4L));
        Assert.assertEquals((long)10L, (long)otherQuotaState.getLastUpdate());
        Assert.assertFalse((boolean)otherQuotaState.isBypass());
        quotaInfo.update((QuotaState)otherQuotaState);
        Assert.assertEquals((long)10L, (long)quotaInfo.getLastUpdate());
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        this.assertThrottleException(quotaInfo.getTableLimiter(TABLE_A), 3);
        this.assertThrottleException(quotaInfo.getTableLimiter(TABLE_B), 4);
        this.assertNoopLimiter(quotaInfo.getTableLimiter(TABLE_C));
        otherQuotaState = new UserQuotaState(20L);
        otherQuotaState.setQuotas(TABLE_A, this.buildReqNumThrottle(11L));
        otherQuotaState.setQuotas(TABLE_C, this.buildReqNumThrottle(5L));
        Assert.assertEquals((long)20L, (long)otherQuotaState.getLastUpdate());
        Assert.assertFalse((boolean)otherQuotaState.isBypass());
        quotaInfo.update((QuotaState)otherQuotaState);
        Assert.assertEquals((long)20L, (long)quotaInfo.getLastUpdate());
        Assert.assertFalse((boolean)quotaInfo.isBypass());
        this.assertThrottleException(quotaInfo.getTableLimiter(TABLE_A), 8);
        this.assertThrottleException(quotaInfo.getTableLimiter(TABLE_C), 5);
        this.assertNoopLimiter(quotaInfo.getTableLimiter(TABLE_B));
        otherQuotaState = new UserQuotaState(30L);
        Assert.assertEquals((long)30L, (long)otherQuotaState.getLastUpdate());
        Assert.assertTrue((boolean)otherQuotaState.isBypass());
        quotaInfo.update((QuotaState)otherQuotaState);
        Assert.assertEquals((long)30L, (long)quotaInfo.getLastUpdate());
        Assert.assertTrue((boolean)quotaInfo.isBypass());
        this.assertNoopLimiter(quotaInfo.getTableLimiter(UNKNOWN_TABLE_NAME));
    }

    private QuotaProtos.Quotas buildReqNumThrottle(long limit) {
        return QuotaProtos.Quotas.newBuilder().setThrottle(QuotaProtos.Throttle.newBuilder().setReqNum(ProtobufUtil.toTimedQuota((long)limit, (TimeUnit)TimeUnit.MINUTES, (QuotaScope)QuotaScope.MACHINE)).build()).build();
    }

    private void assertThrottleException(QuotaLimiter limiter, int availReqs) {
        this.assertNoThrottleException(limiter, availReqs);
        try {
            limiter.checkQuota(1L, 1L);
            Assert.fail((String)"Should have thrown ThrottlingException");
        }
        catch (ThrottlingException throttlingException) {
            // empty catch block
        }
    }

    private void assertNoThrottleException(QuotaLimiter limiter, int availReqs) {
        for (int i = 0; i < availReqs; ++i) {
            try {
                limiter.checkQuota(1L, 1L);
            }
            catch (ThrottlingException e) {
                Assert.fail((String)("Unexpected ThrottlingException after " + i + " requests. limit=" + availReqs));
            }
            limiter.grabQuota(1L, 1L);
        }
    }

    private void assertNoopLimiter(QuotaLimiter limiter) {
        Assert.assertTrue((limiter == NoopQuotaLimiter.get() ? 1 : 0) != 0);
        this.assertNoThrottleException(limiter, 100);
    }
}

