/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegion;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapperStub;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMetricsRegion {
    public MetricsAssertHelper HELPER = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);

    @Test
    public void testRegionWrapperMetrics() {
        MetricsRegion mr = new MetricsRegion((MetricsRegionWrapper)new MetricsRegionWrapperStub());
        MetricsRegionAggregateSource agg = mr.getSource().getAggregateSource();
        this.HELPER.assertGauge("namespace_TestNS_table_MetricsRegionWrapperStub_region_DEADBEEF001_metric_storeCount", 101L, (BaseSource)agg);
        this.HELPER.assertGauge("namespace_TestNS_table_MetricsRegionWrapperStub_region_DEADBEEF001_metric_storeFileCount", 102L, (BaseSource)agg);
        this.HELPER.assertGauge("namespace_TestNS_table_MetricsRegionWrapperStub_region_DEADBEEF001_metric_memstoreSize", 103L, (BaseSource)agg);
        this.HELPER.assertCounter("namespace_TestNS_table_MetricsRegionWrapperStub_region_DEADBEEF001_metric_replicaid", 0L, (BaseSource)agg);
        mr.close();
        mr = new MetricsRegion((MetricsRegionWrapper)new MetricsRegionWrapperStub(1));
        agg = mr.getSource().getAggregateSource();
        this.HELPER.assertGauge("namespace_TestNS_table_MetricsRegionWrapperStub_region_DEADBEEF001_metric_storeCount", 101L, (BaseSource)agg);
        this.HELPER.assertGauge("namespace_TestNS_table_MetricsRegionWrapperStub_region_DEADBEEF001_metric_storeFileCount", 102L, (BaseSource)agg);
        this.HELPER.assertGauge("namespace_TestNS_table_MetricsRegionWrapperStub_region_DEADBEEF001_metric_memstoreSize", 103L, (BaseSource)agg);
        this.HELPER.assertCounter("namespace_TestNS_table_MetricsRegionWrapperStub_region_DEADBEEF001_metric_replicaid", 1L, (BaseSource)agg);
        mr.close();
    }
}

