/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTimeRangeTracker {
    @Test
    public void testAlwaysDecrementingSetsMaximum() {
        TimeRangeTracker trr = new TimeRangeTracker();
        trr.includeTimestamp(3L);
        trr.includeTimestamp(2L);
        trr.includeTimestamp(1L);
        Assert.assertTrue((trr.getMinimumTimestamp() != Long.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((trr.getMaximumTimestamp() != -1L ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleInRange() {
        TimeRangeTracker trr = new TimeRangeTracker();
        trr.includeTimestamp(0L);
        trr.includeTimestamp(2L);
        Assert.assertTrue((boolean)trr.includesTimeRange(new TimeRange(1L)));
    }

    @Test
    public void testArriveAtRightAnswer() throws InterruptedException {
        int i;
        final TimeRangeTracker trr = new TimeRangeTracker();
        int threadCount = 10;
        int calls = 1000000;
        Thread[] threads = new Thread[10];
        for (i = 0; i < threads.length; ++i) {
            Thread t = new Thread("" + i){

                @Override
                public void run() {
                    boolean even;
                    int offset = Integer.parseInt(this.getName());
                    boolean bl = even = offset % 2 == 0;
                    if (even) {
                        for (int i = offset * 1000000; i < 1000000; ++i) {
                            trr.includeTimestamp((long)i);
                        }
                    } else {
                        int base = offset * 1000000;
                        for (int i = base + 1000000; i >= base; --i) {
                            trr.includeTimestamp((long)i);
                        }
                    }
                }
            };
            t.start();
            threads[i] = t;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        Assert.assertTrue((trr.getMaximumTimestamp() == 10000000L ? 1 : 0) != 0);
        Assert.assertTrue((trr.getMinimumTimestamp() == 0L ? 1 : 0) != 0);
    }

    public static void main(String[] args) throws InterruptedException {
        int i;
        long start = System.currentTimeMillis();
        final TimeRangeTracker trr = new TimeRangeTracker();
        int threadCount = 5;
        int calls = 0x8000000;
        Thread[] threads = new Thread[5];
        for (i = 0; i < threads.length; ++i) {
            Thread t = new Thread("" + i){

                @Override
                public void run() {
                    for (int i = 0; i < 0x8000000; ++i) {
                        trr.includeTimestamp((long)i);
                    }
                }
            };
            t.start();
            threads[i] = t;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        System.out.println(trr.getMinimumTimestamp() + " " + trr.getMaximumTimestamp() + " " + (System.currentTimeMillis() - start));
    }
}

