/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.BaseWALObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.TestRegionServerNoMaster;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.RegionReplicaReplicationEndpoint;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestRegionReplicaReplicationEndpointNoMaster {
    private static final Log LOG = LogFactory.getLog(TestRegionReplicaReplicationEndpointNoMaster.class);
    private static final int NB_SERVERS = 2;
    private static TableName tableName = TableName.valueOf((String)TestRegionReplicaReplicationEndpointNoMaster.class.getSimpleName());
    private static HTable table;
    private static final byte[] row;
    private static HRegionServer rs0;
    private static HRegionServer rs1;
    private static HRegionInfo hriPrimary;
    private static HRegionInfo hriSecondary;
    private static final HBaseTestingUtility HTU;
    private static final byte[] f;
    static ConcurrentLinkedQueue<WAL.Entry> entries;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = HTU.getConfiguration();
        conf.setBoolean("hbase.replication", true);
        conf.setBoolean("hbase.region.replica.replication.enabled", true);
        conf.setBoolean("hbase.region.replica.wait.for.primary.flush", false);
        String walCoprocs = HTU.getConfiguration().get("hbase.coprocessor.wal.classes");
        walCoprocs = walCoprocs == null ? WALEditCopro.class.getName() : walCoprocs + "," + WALEditCopro.class.getName();
        HTU.getConfiguration().set("hbase.coprocessor.wal.classes", walCoprocs);
        HTU.startMiniCluster(2);
        HTableDescriptor htd = HTU.createTableDescriptor(tableName.toString());
        table = HTU.createTable(htd, (byte[][])new byte[][]{f}, HTU.getConfiguration());
        hriPrimary = table.getRegionLocation(row, false).getRegionInfo();
        hriSecondary = new HRegionInfo(hriPrimary.getTable(), hriPrimary.getStartKey(), hriPrimary.getEndKey(), hriPrimary.isSplit(), hriPrimary.getRegionId(), 1);
        TestRegionServerNoMaster.stopMasterAndAssignMeta(HTU);
        rs0 = HTU.getMiniHBaseCluster().getRegionServer(0);
        rs1 = HTU.getMiniHBaseCluster().getRegionServer(1);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        table.close();
        HTU.shutdownMiniCluster();
    }

    @Before
    public void before() throws Exception {
        entries.clear();
    }

    @After
    public void after() throws Exception {
    }

    @Test(timeout=240000L)
    public void testReplayCallable() throws Exception {
        TestRegionServerNoMaster.openRegion(HTU, rs0, hriSecondary);
        ClusterConnection connection = (ClusterConnection)ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        HTU.loadNumericRows((Table)table, f, 0, 1000);
        Assert.assertEquals((long)1000L, (long)entries.size());
        this.replicateUsingCallable(connection, entries);
        Region region = rs0.getFromOnlineRegions(hriSecondary.getEncodedName());
        HTU.verifyNumericRows(region, f, 0, 1000);
        HTU.deleteNumericRows(table, f, 0, 1000);
        TestRegionServerNoMaster.closeRegion(HTU, rs0, hriSecondary);
        connection.close();
    }

    private void replicateUsingCallable(ClusterConnection connection, Queue<WAL.Entry> entries) throws IOException, RuntimeException {
        WAL.Entry entry;
        while ((entry = entries.poll()) != null) {
            byte[] row = ((Cell)entry.getEdit().getCells().get(0)).getRow();
            RegionLocations locations = connection.locateRegion(tableName, row, true, true);
            RegionReplicaReplicationEndpoint.RegionReplicaReplayCallable callable = new RegionReplicaReplicationEndpoint.RegionReplicaReplayCallable(connection, RpcControllerFactory.instantiate((Configuration)connection.getConfiguration()), table.getName(), locations.getRegionLocation(1), locations.getRegionLocation(1).getRegionInfo(), row, (List)Lists.newArrayList((Object[])new WAL.Entry[]{entry}), new AtomicLong());
            RpcRetryingCallerFactory factory = RpcRetryingCallerFactory.instantiate((Configuration)connection.getConfiguration());
            factory.newCaller().callWithRetries((RetryingCallable)callable, 10000);
        }
    }

    @Test(timeout=240000L)
    public void testReplayCallableWithRegionMove() throws Exception {
        TestRegionServerNoMaster.openRegion(HTU, rs0, hriSecondary);
        ClusterConnection connection = (ClusterConnection)ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        HTU.loadNumericRows((Table)table, f, 0, 1000);
        Assert.assertEquals((long)1000L, (long)entries.size());
        this.replicateUsingCallable(connection, entries);
        Region region = rs0.getFromOnlineRegions(hriSecondary.getEncodedName());
        HTU.verifyNumericRows(region, f, 0, 1000);
        HTU.loadNumericRows((Table)table, f, 1000, 2000);
        TestRegionServerNoMaster.closeRegion(HTU, rs0, hriSecondary);
        TestRegionServerNoMaster.openRegion(HTU, rs1, hriSecondary);
        this.replicateUsingCallable(connection, entries);
        region = rs1.getFromOnlineRegions(hriSecondary.getEncodedName());
        HTU.verifyNumericRows(region, f, 1000, 2000);
        HTU.deleteNumericRows(table, f, 0, 2000);
        TestRegionServerNoMaster.closeRegion(HTU, rs1, hriSecondary);
        connection.close();
    }

    @Test(timeout=240000L)
    public void testRegionReplicaReplicationEndpointReplicate() throws Exception {
        TestRegionServerNoMaster.openRegion(HTU, rs0, hriSecondary);
        ClusterConnection connection = (ClusterConnection)ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        RegionReplicaReplicationEndpoint replicator = new RegionReplicaReplicationEndpoint();
        ReplicationEndpoint.Context context = (ReplicationEndpoint.Context)Mockito.mock(ReplicationEndpoint.Context.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)HTU.getConfiguration());
        Mockito.when((Object)context.getMetrics()).thenReturn(Mockito.mock(MetricsSource.class));
        replicator.init(context);
        replicator.start();
        HTU.loadNumericRows((Table)table, f, 0, 1000);
        Assert.assertEquals((long)1000L, (long)entries.size());
        String fakeWalGroupId = "fakeWALGroup";
        replicator.replicate(new ReplicationEndpoint.ReplicateContext().setEntries((List)Lists.newArrayList(entries)).setWalGroupId("fakeWALGroup"));
        Region region = rs0.getFromOnlineRegions(hriSecondary.getEncodedName());
        HTU.verifyNumericRows(region, f, 0, 1000);
        HTU.deleteNumericRows(table, f, 0, 1000);
        TestRegionServerNoMaster.closeRegion(HTU, rs0, hriSecondary);
        connection.close();
    }

    @Test(timeout=240000L)
    public void testReplayedEditsAreSkipped() throws Exception {
        TestRegionServerNoMaster.openRegion(HTU, rs0, hriSecondary);
        ClusterConnection connection = (ClusterConnection)ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        RegionReplicaReplicationEndpoint replicator = new RegionReplicaReplicationEndpoint();
        ReplicationEndpoint.Context context = (ReplicationEndpoint.Context)Mockito.mock(ReplicationEndpoint.Context.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)HTU.getConfiguration());
        Mockito.when((Object)context.getMetrics()).thenReturn(Mockito.mock(MetricsSource.class));
        ReplicationPeer mockPeer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
        Mockito.when((Object)mockPeer.getTableCFs()).thenReturn(null);
        Mockito.when((Object)context.getReplicationPeer()).thenReturn((Object)mockPeer);
        replicator.init(context);
        replicator.start();
        WALEntryFilter filter = replicator.getWALEntryfilter();
        HTU.loadNumericRows((Table)table, f, 0, 1000);
        Assert.assertEquals((long)1000L, (long)entries.size());
        for (WAL.Entry e : entries) {
            if (Integer.parseInt(Bytes.toString((byte[])((Cell)e.getEdit().getCells().get(0)).getValue())) % 2 != 0) continue;
            e.getKey().setOrigLogSeqNum(1L);
        }
        long skipped = 0L;
        long replayed = 0L;
        for (WAL.Entry e : entries) {
            if (filter.filter(e) == null) {
                ++skipped;
                continue;
            }
            ++replayed;
        }
        Assert.assertEquals((long)500L, (long)skipped);
        Assert.assertEquals((long)500L, (long)replayed);
        HTU.deleteNumericRows(table, f, 0, 1000);
        TestRegionServerNoMaster.closeRegion(HTU, rs0, hriSecondary);
        connection.close();
    }

    static {
        row = "TestRegionReplicaReplicator".getBytes();
        HTU = new HBaseTestingUtility();
        f = HConstants.CATALOG_FAMILY;
        entries = new ConcurrentLinkedQueue();
    }

    public static class WALEditCopro
    extends BaseWALObserver {
        public WALEditCopro() {
            entries.clear();
        }

        public void postWALWrite(ObserverContext<? extends WALCoprocessorEnvironment> ctx, HRegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
            if (logKey.getTablename().equals((Object)tableName) && info.getReplicaId() == 0) {
                entries.add(new WAL.Entry(logKey, logEdit));
            }
        }
    }
}

