/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.FSVisitor;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.junit.Assert;

@InterfaceAudience.Private
public final class SnapshotTestingUtils {
    private static final Log LOG = LogFactory.getLog(SnapshotTestingUtils.class);
    private static byte[] KEYS = Bytes.toBytes((String)"0123456789");

    private SnapshotTestingUtils() {
    }

    public static void assertNoSnapshots(Admin admin) throws IOException {
        Assert.assertEquals((String)"Have some previous snapshots", (long)0L, (long)admin.listSnapshots().size());
    }

    public static List<HBaseProtos.SnapshotDescription> assertExistsMatchingSnapshot(Admin admin, String snapshotName, TableName tableName) throws IOException {
        List snapshots = admin.listSnapshots();
        ArrayList<HBaseProtos.SnapshotDescription> returnedSnapshots = new ArrayList<HBaseProtos.SnapshotDescription>();
        for (HBaseProtos.SnapshotDescription sd : snapshots) {
            if (!snapshotName.equals(sd.getName()) || !tableName.equals((Object)TableName.valueOf((String)sd.getTable()))) continue;
            returnedSnapshots.add(sd);
        }
        Assert.assertTrue((String)"No matching snapshots found.", (returnedSnapshots.size() > 0 ? 1 : 0) != 0);
        return returnedSnapshots;
    }

    public static void assertOneSnapshotThatMatches(Admin admin, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, snapshot.getName(), TableName.valueOf((String)snapshot.getTable()));
    }

    public static List<HBaseProtos.SnapshotDescription> assertOneSnapshotThatMatches(Admin admin, String snapshotName, TableName tableName) throws IOException {
        List snapshots = admin.listSnapshots();
        Assert.assertEquals((String)"Should only have 1 snapshot", (long)1L, (long)snapshots.size());
        Assert.assertEquals((Object)snapshotName, (Object)((HBaseProtos.SnapshotDescription)snapshots.get(0)).getName());
        Assert.assertEquals((Object)tableName, (Object)TableName.valueOf((String)((HBaseProtos.SnapshotDescription)snapshots.get(0)).getTable()));
        return snapshots;
    }

    public static List<HBaseProtos.SnapshotDescription> assertOneSnapshotThatMatches(Admin admin, byte[] snapshot, TableName tableName) throws IOException {
        return SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, Bytes.toString((byte[])snapshot), tableName);
    }

    public static void confirmSnapshotValid(HBaseTestingUtility testUtil, HBaseProtos.SnapshotDescription snapshotDescriptor, TableName tableName, byte[] family) throws IOException {
        MasterFileSystem mfs = testUtil.getHBaseCluster().getMaster().getMasterFileSystem();
        SnapshotTestingUtils.confirmSnapshotValid(snapshotDescriptor, tableName, family, mfs.getRootDir(), (Admin)testUtil.getHBaseAdmin(), mfs.getFileSystem());
    }

    public static void confirmSnapshotValid(HBaseProtos.SnapshotDescription snapshotDescriptor, TableName tableName, byte[] testFamily, Path rootDir, Admin admin, FileSystem fs) throws IOException {
        ArrayList<byte[]> nonEmptyTestFamilies = new ArrayList<byte[]>(1);
        nonEmptyTestFamilies.add(testFamily);
        SnapshotTestingUtils.confirmSnapshotValid(snapshotDescriptor, tableName, nonEmptyTestFamilies, null, rootDir, admin, fs);
    }

    public static void confirmEmptySnapshotValid(HBaseProtos.SnapshotDescription snapshotDescriptor, TableName tableName, byte[] testFamily, Path rootDir, Admin admin, FileSystem fs) throws IOException {
        ArrayList<byte[]> emptyTestFamilies = new ArrayList<byte[]>(1);
        emptyTestFamilies.add(testFamily);
        SnapshotTestingUtils.confirmSnapshotValid(snapshotDescriptor, tableName, null, emptyTestFamilies, rootDir, admin, fs);
    }

    public static void confirmSnapshotValid(HBaseProtos.SnapshotDescription snapshotDescriptor, TableName tableName, List<byte[]> nonEmptyTestFamilies, List<byte[]> emptyTestFamilies, Path rootDir, Admin admin, FileSystem fs) throws IOException {
        Configuration conf = admin.getConfiguration();
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((HBaseProtos.SnapshotDescription)snapshotDescriptor, (Path)rootDir);
        Assert.assertTrue((boolean)fs.exists(snapshotDir));
        HBaseProtos.SnapshotDescription desc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)fs, (Path)snapshotDir);
        final TreeSet snapshotFamilies = new TreeSet(Bytes.BYTES_COMPARATOR);
        SnapshotManifest manifest = SnapshotManifest.open((Configuration)conf, (FileSystem)fs, (Path)snapshotDir, (HBaseProtos.SnapshotDescription)desc);
        Map regionManifests = manifest.getRegionManifestsMap();
        for (SnapshotProtos.SnapshotRegionManifest regionManifest : regionManifests.values()) {
            SnapshotReferenceUtil.visitRegionStoreFiles((SnapshotProtos.SnapshotRegionManifest)regionManifest, (SnapshotReferenceUtil.StoreFileVisitor)new SnapshotReferenceUtil.StoreFileVisitor(){

                public void storeFile(HRegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                    snapshotFamilies.add(Bytes.toBytes((String)family));
                }
            });
        }
        if (nonEmptyTestFamilies != null) {
            for (byte[] familyName : nonEmptyTestFamilies) {
                Assert.assertTrue((boolean)snapshotFamilies.contains(familyName));
            }
        }
        if (emptyTestFamilies != null) {
            for (byte[] familyName : emptyTestFamilies) {
                Assert.assertFalse((boolean)snapshotFamilies.contains(familyName));
            }
        }
        List regions = admin.getTableRegions(tableName);
        RegionReplicaUtil.removeNonDefaultRegions((Collection)regions);
        Assert.assertEquals((long)regions.size(), (long)regionManifests.size());
        for (HRegionInfo info : regions) {
            String regionName = info.getEncodedName();
            Assert.assertTrue((boolean)regionManifests.containsKey(regionName));
        }
    }

    public static void waitForSnapshotToComplete(HMaster master, HBaseProtos.SnapshotDescription snapshot, long sleep) throws ServiceException {
        MasterProtos.IsSnapshotDoneRequest request = MasterProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build();
        MasterProtos.IsSnapshotDoneResponse done = MasterProtos.IsSnapshotDoneResponse.newBuilder().buildPartial();
        while (!done.getDone()) {
            done = master.getMasterRpcServices().isSnapshotDone(null, request);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }

    public static void snapshot(Admin admin, String snapshotName, String tableName, HBaseProtos.SnapshotDescription.Type type, int numTries) throws IOException {
        int tries = 0;
        CorruptedSnapshotException lastEx = null;
        while (tries++ < numTries) {
            try {
                admin.snapshot(snapshotName, TableName.valueOf((String)tableName), type);
                return;
            }
            catch (CorruptedSnapshotException cse) {
                LOG.warn((Object)"Got CorruptedSnapshotException", (Throwable)cse);
                lastEx = cse;
            }
        }
        throw lastEx;
    }

    public static void cleanupSnapshot(Admin admin, byte[] tableName) throws IOException {
        SnapshotTestingUtils.cleanupSnapshot(admin, Bytes.toString((byte[])tableName));
    }

    public static void cleanupSnapshot(Admin admin, String snapshotName) throws IOException {
        admin.deleteSnapshot(snapshotName);
        SnapshotTestingUtils.assertNoSnapshots(admin);
    }

    public static void expectSnapshotDoneException(HMaster master, MasterProtos.IsSnapshotDoneRequest snapshot, Class<? extends HBaseSnapshotException> clazz) {
        try {
            master.getMasterRpcServices().isSnapshotDone(null, snapshot);
            Assert.fail((String)"didn't fail to lookup a snapshot");
        }
        catch (ServiceException se) {
            try {
                throw ProtobufUtil.getRemoteException((ServiceException)se);
            }
            catch (HBaseSnapshotException e) {
                Assert.assertEquals((String)"Threw wrong snapshot exception!", clazz, ((Object)((Object)e)).getClass());
            }
            catch (Throwable t) {
                Assert.fail((String)("Threw an unexpected exception:" + t));
            }
        }
    }

    public static ArrayList<String> listHFileNames(FileSystem fs, Path tableDir) throws IOException {
        final ArrayList<String> hfiles = new ArrayList<String>();
        FSVisitor.visitTableStoreFiles((FileSystem)fs, (Path)tableDir, (FSVisitor.StoreFileVisitor)new FSVisitor.StoreFileVisitor(){

            public void storeFile(String region, String family, String hfileName) throws IOException {
                hfiles.add(hfileName);
            }
        });
        Collections.sort(hfiles);
        return hfiles;
    }

    public static void createSnapshotAndValidate(Admin admin, TableName tableName, String familyName, String snapshotNameString, Path rootDir, FileSystem fs, boolean onlineSnapshot) throws Exception {
        ArrayList<byte[]> nonEmptyFamilyNames = new ArrayList<byte[]>(1);
        nonEmptyFamilyNames.add(Bytes.toBytes((String)familyName));
        SnapshotTestingUtils.createSnapshotAndValidate(admin, tableName, nonEmptyFamilyNames, null, snapshotNameString, rootDir, fs, onlineSnapshot);
    }

    public static void createSnapshotAndValidate(Admin admin, TableName tableName, List<byte[]> nonEmptyFamilyNames, List<byte[]> emptyFamilyNames, String snapshotNameString, Path rootDir, FileSystem fs, boolean onlineSnapshot) throws Exception {
        if (!onlineSnapshot) {
            try {
                admin.disableTable(tableName);
            }
            catch (TableNotEnabledException tne) {
                LOG.info((Object)("In attempting to disable " + tableName + " it turns out that the this table is " + "already disabled."));
            }
        }
        admin.snapshot(snapshotNameString, tableName);
        List<HBaseProtos.SnapshotDescription> snapshots = SnapshotTestingUtils.assertExistsMatchingSnapshot(admin, snapshotNameString, tableName);
        if (snapshots == null || snapshots.size() != 1) {
            Assert.fail((String)("Incorrect number of snapshots for table " + tableName));
        }
        SnapshotTestingUtils.confirmSnapshotValid(snapshots.get(0), tableName, nonEmptyFamilyNames, emptyFamilyNames, rootDir, admin, fs);
    }

    public static ArrayList corruptSnapshot(HBaseTestingUtility util, String snapshotName) throws IOException {
        MasterFileSystem mfs = util.getHBaseCluster().getMaster().getMasterFileSystem();
        final FileSystem fs = mfs.getFileSystem();
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)mfs.getRootDir());
        HBaseProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)fs, (Path)snapshotDir);
        final TableName table = TableName.valueOf((String)snapshotDesc.getTable());
        final ArrayList corruptedFiles = new ArrayList();
        final Configuration conf = util.getConfiguration();
        SnapshotReferenceUtil.visitTableStoreFiles((Configuration)conf, (FileSystem)fs, (Path)snapshotDir, (HBaseProtos.SnapshotDescription)snapshotDesc, (SnapshotReferenceUtil.StoreFileVisitor)new SnapshotReferenceUtil.StoreFileVisitor(){

            public void storeFile(HRegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                String region = regionInfo.getEncodedName();
                String hfile = storeFile.getName();
                HFileLink link = HFileLink.build((Configuration)conf, (TableName)table, (String)region, (String)family, (String)hfile);
                if (corruptedFiles.size() % 2 == 0) {
                    fs.delete(link.getAvailablePath(fs), true);
                    corruptedFiles.add(hfile);
                }
            }
        });
        Assert.assertTrue((corruptedFiles.size() > 0 ? 1 : 0) != 0);
        return corruptedFiles;
    }

    public static void waitForTableToBeOnline(HBaseTestingUtility util, TableName tableName) throws IOException, InterruptedException {
        HRegionServer rs = util.getRSForFirstRegionInTable(tableName);
        List onlineRegions = rs.getOnlineRegions(tableName);
        for (Region region : onlineRegions) {
            region.waitForFlushesAndCompactions();
        }
        util.waitFor(60000L, util.predicateTableAvailable(tableName));
    }

    public static void createTable(HBaseTestingUtility util, TableName tableName, int regionReplication, byte[] ... families) throws IOException, InterruptedException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.setRegionReplication(regionReplication);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            htd.addFamily(hcd);
        }
        byte[][] splitKeys = SnapshotTestingUtils.getSplitKeys();
        util.createTable(htd, splitKeys);
        Assert.assertEquals((long)((splitKeys.length + 1) * regionReplication), (long)util.getHBaseAdmin().getTableRegions(tableName).size());
    }

    public static byte[][] getSplitKeys() {
        byte[][] splitKeys = new byte[KEYS.length - 2][];
        for (int i = 0; i < splitKeys.length; ++i) {
            splitKeys[i] = new byte[]{KEYS[i + 1]};
        }
        return splitKeys;
    }

    public static void createTable(HBaseTestingUtility util, TableName tableName, byte[] ... families) throws IOException, InterruptedException {
        SnapshotTestingUtils.createTable(util, tableName, 1, families);
    }

    public static void loadData(HBaseTestingUtility util, TableName tableName, int rows, byte[] ... families) throws IOException, InterruptedException {
        try (BufferedMutator mutator = util.getConnection().getBufferedMutator(tableName);){
            SnapshotTestingUtils.loadData(util, mutator, rows, families);
        }
    }

    public static void loadData(HBaseTestingUtility util, BufferedMutator mutator, int rows, byte[] ... families) throws IOException, InterruptedException {
        Assert.assertTrue((rows >= KEYS.length ? 1 : 0) != 0);
        for (byte k0 : KEYS) {
            byte[] k = new byte[]{k0};
            byte[] value = Bytes.add((byte[])Bytes.toBytes((long)System.currentTimeMillis()), (byte[])k);
            byte[] key = Bytes.add((byte[])k, (byte[])Bytes.toBytes((String)MD5Hash.getMD5AsHex((byte[])value)));
            byte[][] families1 = families;
            byte[] key1 = key;
            byte[] value1 = value;
            mutator.mutate((Mutation)SnapshotTestingUtils.createPut(families1, key1, value1));
            --rows;
        }
        while (rows-- > 0) {
            byte[] value = Bytes.add((byte[])Bytes.toBytes((long)System.currentTimeMillis()), (byte[])Bytes.toBytes((int)rows));
            byte[] key = Bytes.toBytes((String)MD5Hash.getMD5AsHex((byte[])value));
            byte[][] families1 = families;
            byte[] key1 = key;
            byte[] value1 = value;
            mutator.mutate((Mutation)SnapshotTestingUtils.createPut(families1, key1, value1));
        }
        mutator.flush();
        SnapshotTestingUtils.waitForTableToBeOnline(util, mutator.getName());
    }

    private static Put createPut(byte[][] families, byte[] key, byte[] value) {
        byte[] q = Bytes.toBytes((String)"q");
        Put put = new Put(key);
        put.setDurability(Durability.SKIP_WAL);
        for (byte[] family : families) {
            put.add(family, q, value);
        }
        return put;
    }

    public static void deleteAllSnapshots(Admin admin) throws IOException {
        for (HBaseProtos.SnapshotDescription snapshot : admin.listSnapshots()) {
            admin.deleteSnapshot(snapshot.getName());
        }
        SnapshotTestingUtils.assertNoSnapshots(admin);
    }

    public static void deleteArchiveDirectory(HBaseTestingUtility util) throws IOException {
        MasterFileSystem mfs = util.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path archiveDir = new Path(mfs.getRootDir(), "archive");
        mfs.getFileSystem().delete(archiveDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyRowCount(HBaseTestingUtility util, TableName tableName, long expectedRows) throws IOException {
        try (HTable table = new HTable(util.getConfiguration(), tableName);){
            Assert.assertEquals((long)expectedRows, (long)util.countRows((Table)table));
        }
    }

    public static void verifyReplicasCameOnline(TableName tableName, Admin admin, int regionReplication) throws IOException {
        List regions = admin.getTableRegions(tableName);
        HashSet<HRegionInfo> set = new HashSet<HRegionInfo>();
        for (HRegionInfo hri : regions) {
            set.add(RegionReplicaUtil.getRegionInfoForDefaultReplica((HRegionInfo)hri));
            for (int i = 0; i < regionReplication; ++i) {
                HRegionInfo replica = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)hri, (int)i);
                if (regions.contains(replica)) continue;
                Assert.fail((String)(replica + " is not contained in the list of online regions"));
            }
        }
        assert (set.size() == SnapshotTestingUtils.getSplitKeys().length + 1);
    }

    public static class SnapshotMock {
        private static final String TEST_FAMILY = "cf";
        public static final int TEST_NUM_REGIONS = 4;
        private final Configuration conf;
        private final FileSystem fs;
        private final Path rootDir;

        public SnapshotMock(Configuration conf, FileSystem fs, Path rootDir) {
            this.fs = fs;
            this.conf = conf;
            this.rootDir = rootDir;
        }

        public SnapshotBuilder createSnapshotV1(String snapshotName, String tableName) throws IOException {
            return this.createSnapshot(snapshotName, tableName, 0);
        }

        public SnapshotBuilder createSnapshotV1(String snapshotName, String tableName, int numRegions) throws IOException {
            return this.createSnapshot(snapshotName, tableName, numRegions, 0);
        }

        public SnapshotBuilder createSnapshotV2(String snapshotName, String tableName) throws IOException {
            return this.createSnapshot(snapshotName, tableName, 2);
        }

        public SnapshotBuilder createSnapshotV2(String snapshotName, String tableName, int numRegions) throws IOException {
            return this.createSnapshot(snapshotName, tableName, numRegions, 2);
        }

        private SnapshotBuilder createSnapshot(String snapshotName, String tableName, int version) throws IOException {
            return this.createSnapshot(snapshotName, tableName, 4, version);
        }

        private SnapshotBuilder createSnapshot(String snapshotName, String tableName, int numRegions, int version) throws IOException {
            HTableDescriptor htd = this.createHtd(tableName);
            RegionData[] regions = this.createTable(htd, numRegions);
            HBaseProtos.SnapshotDescription desc = HBaseProtos.SnapshotDescription.newBuilder().setTable(htd.getNameAsString()).setName(snapshotName).setVersion(version).build();
            Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((HBaseProtos.SnapshotDescription)desc, (Path)this.rootDir);
            SnapshotDescriptionUtils.writeSnapshotInfo((HBaseProtos.SnapshotDescription)desc, (Path)workingDir, (FileSystem)this.fs);
            return new SnapshotBuilder(this.conf, this.fs, this.rootDir, htd, desc, regions);
        }

        public HTableDescriptor createHtd(String tableName) {
            HTableDescriptor htd = new HTableDescriptor(tableName);
            htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
            return htd;
        }

        private RegionData[] createTable(HTableDescriptor htd, int nregions) throws IOException {
            Path tableDir = FSUtils.getTableDir((Path)this.rootDir, (TableName)htd.getTableName());
            new FSTableDescriptors(this.conf).createTableDescriptorForTableDirectory(tableDir, htd, false);
            Assert.assertTrue((nregions % 2 == 0 ? 1 : 0) != 0);
            RegionData[] regions = new RegionData[nregions];
            for (int i = 0; i < regions.length; i += 2) {
                int j;
                byte[] startKey = Bytes.toBytes((int)(0 + i * 2));
                byte[] endKey = Bytes.toBytes((int)(1 + i * 2));
                HRegionInfo hri = new HRegionInfo(htd.getTableName(), startKey, endKey);
                HRegionFileSystem rfs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)tableDir, (HRegionInfo)hri);
                regions[i] = new RegionData(tableDir, hri, 3);
                for (j = 0; j < regions[i].files.length; ++j) {
                    Path storeFile = this.createStoreFile(rfs.createTempName());
                    regions[i].files[j] = rfs.commitStoreFile(TEST_FAMILY, storeFile);
                }
                startKey = Bytes.toBytes((int)(2 + i * 2));
                endKey = Bytes.toBytes((int)(3 + i * 2));
                hri = new HRegionInfo(htd.getTableName());
                rfs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)tableDir, (HRegionInfo)hri);
                regions[i + 1] = new RegionData(tableDir, hri, regions[i].files.length);
                for (j = 0; j < regions[i].files.length; ++j) {
                    String refName = regions[i].files[j].getName() + '.' + regions[i].hri.getEncodedName();
                    Path refFile = this.createStoreFile(new Path(this.rootDir, refName));
                    regions[i + 1].files[j] = rfs.commitStoreFile(TEST_FAMILY, refFile);
                }
            }
            return regions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Path createStoreFile(Path storeFile) throws IOException {
            try (FSDataOutputStream out = this.fs.create(storeFile);){
                out.write(Bytes.toBytes((String)storeFile.toString()));
            }
            return storeFile;
        }

        public static class SnapshotBuilder {
            private final RegionData[] tableRegions;
            private final HBaseProtos.SnapshotDescription desc;
            private final HTableDescriptor htd;
            private final Configuration conf;
            private final FileSystem fs;
            private final Path rootDir;
            private Path snapshotDir;
            private int snapshotted = 0;

            public SnapshotBuilder(Configuration conf, FileSystem fs, Path rootDir, HTableDescriptor htd, HBaseProtos.SnapshotDescription desc, RegionData[] tableRegions) throws IOException {
                this.fs = fs;
                this.conf = conf;
                this.rootDir = rootDir;
                this.htd = htd;
                this.desc = desc;
                this.tableRegions = tableRegions;
                this.snapshotDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((HBaseProtos.SnapshotDescription)desc, (Path)rootDir);
                new FSTableDescriptors(conf).createTableDescriptorForTableDirectory(this.snapshotDir, htd, false);
            }

            public HTableDescriptor getTableDescriptor() {
                return this.htd;
            }

            public HBaseProtos.SnapshotDescription getSnapshotDescription() {
                return this.desc;
            }

            public Path getSnapshotsDir() {
                return this.snapshotDir;
            }

            public Path[] addRegion() throws IOException {
                return this.addRegion(this.desc);
            }

            public Path[] addRegionV1() throws IOException {
                return this.addRegion(this.desc.toBuilder().setVersion(0).build());
            }

            public Path[] addRegionV2() throws IOException {
                return this.addRegion(this.desc.toBuilder().setVersion(2).build());
            }

            private Path[] addRegion(HBaseProtos.SnapshotDescription desc) throws IOException {
                if (this.snapshotted == this.tableRegions.length) {
                    throw new UnsupportedOperationException("No more regions in the table");
                }
                RegionData regionData = this.tableRegions[this.snapshotted++];
                ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(desc.getName());
                SnapshotManifest manifest = SnapshotManifest.create((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (HBaseProtos.SnapshotDescription)desc, (ForeignExceptionSnare)monitor);
                manifest.addRegion(regionData.tableDir, regionData.hri);
                return regionData.files;
            }

            private void corruptFile(Path p) throws IOException {
                String manifestName = p.getName();
                Path newP = new Path(p.getParent(), manifestName + "1");
                this.fs.rename(p, newP);
                FSDataOutputStream out = this.fs.create(p);
                FSDataInputStream input = this.fs.open(newP);
                byte[] buffer = new byte[25];
                int len = input.read(0L, buffer, 0, 25);
                if (len > 1) {
                    out.write(buffer, 0, len - 1);
                }
                out.close();
                this.fs.delete(newP);
            }

            public void corruptOneRegionManifest() throws IOException {
                FileStatus[] manifestFiles = FSUtils.listStatus((FileSystem)this.fs, (Path)this.snapshotDir, (PathFilter)new PathFilter(){

                    public boolean accept(Path path) {
                        return path.getName().startsWith("region-manifest.");
                    }
                });
                if (manifestFiles.length == 0) {
                    return;
                }
                Path p = manifestFiles[0].getPath();
                this.corruptFile(p);
            }

            public void missOneRegionSnapshotFile() throws IOException {
                FileStatus[] manifestFiles;
                for (FileStatus fileStatus : manifestFiles = FSUtils.listStatus((FileSystem)this.fs, (Path)this.snapshotDir)) {
                    String fileName = fileStatus.getPath().getName();
                    if (!fileName.endsWith(".snapshotinfo") && !fileName.endsWith(".tabledesc") && !fileName.endsWith(".tmp")) continue;
                    this.fs.delete(fileStatus.getPath(), true);
                }
            }

            public void corruptDataManifest() throws IOException {
                FileStatus[] manifestFiles = FSUtils.listStatus((FileSystem)this.fs, (Path)this.snapshotDir, (PathFilter)new PathFilter(){

                    public boolean accept(Path path) {
                        return path.getName().startsWith("data.manifest");
                    }
                });
                if (manifestFiles.length == 0) {
                    return;
                }
                Path p = manifestFiles[0].getPath();
                this.corruptFile(p);
            }

            public Path commit() throws IOException {
                ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(this.desc.getName());
                SnapshotManifest manifest = SnapshotManifest.create((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (HBaseProtos.SnapshotDescription)this.desc, (ForeignExceptionSnare)monitor);
                manifest.addTableDescriptor(this.htd);
                manifest.consolidate();
                SnapshotDescriptionUtils.completeSnapshot((HBaseProtos.SnapshotDescription)this.desc, (Path)this.rootDir, (Path)this.snapshotDir, (FileSystem)this.fs);
                this.snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((HBaseProtos.SnapshotDescription)this.desc, (Path)this.rootDir);
                return this.snapshotDir;
            }

            public void consolidate() throws IOException {
                ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(this.desc.getName());
                SnapshotManifest manifest = SnapshotManifest.create((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (HBaseProtos.SnapshotDescription)this.desc, (ForeignExceptionSnare)monitor);
                manifest.addTableDescriptor(this.htd);
                manifest.consolidate();
            }
        }

        static class RegionData {
            public HRegionInfo hri;
            public Path tableDir;
            public Path[] files;

            public RegionData(Path tableDir, HRegionInfo hri, int nfiles) {
                this.tableDir = tableDir;
                this.hri = hri;
                this.files = new Path[nfiles];
            }
        }
    }
}

