/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ConfigurationUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestConfigurationUtil {
    private Configuration conf;
    private Map<String, String> keyValues;
    private String key;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.keyValues = ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2");
        this.key = "my_conf_key";
    }

    public void callSetKeyValues() {
        ConfigurationUtil.setKeyValues((Configuration)this.conf, (String)this.key, this.keyValues.entrySet());
    }

    public List<Map.Entry<String, String>> callGetKeyValues() {
        return ConfigurationUtil.getKeyValues((Configuration)this.conf, (String)this.key);
    }

    @Test
    public void testGetAndSetKeyValuesWithValues() throws Exception {
        this.callSetKeyValues();
        Assert.assertEquals((Object)Lists.newArrayList(this.keyValues.entrySet()), this.callGetKeyValues());
    }

    @Test
    public void testGetKeyValuesWithUnsetKey() throws Exception {
        Assert.assertNull(this.callGetKeyValues());
    }
}

