/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class TOMAP
extends EvalFunc<Map> {
    @Override
    public Map exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        HashMap<String, Object> output = new HashMap<String, Object>();
        try {
            if (input.size() == 1) {
                if (input.get(0) instanceof DataBag) {
                    DataBag bagOfPairs = (DataBag)input.get(0);
                    if (bagOfPairs.size() == 0L) {
                        return output;
                    }
                    for (Tuple tuple : bagOfPairs) {
                        if (tuple.size() != 2) {
                            throw new RuntimeException("All input tuples in the bag MUST have exactly 2 fields");
                        }
                        String key = (String)tuple.get(0);
                        Object val = tuple.get(1);
                        output.put(key, val);
                    }
                    return output;
                }
                return null;
            }
            for (int i = 0; i < input.size(); i += 2) {
                String key = (String)input.get(i);
                Object val = input.get(i + 1);
                output.put(key, val);
            }
            return output;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Map key must be a String");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Function input must have even number of parameters");
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating a map", e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        Byte valueType;
        block5: {
            block4: {
                Schema tupleSchema;
                valueType = null;
                if (input.size() != 1) break block4;
                Schema bagSchema = input.getFields().get((int)0).schema;
                if (bagSchema == null || bagSchema.size() != 1 || (tupleSchema = bagSchema.getFields().get((int)0).schema) == null) break block5;
                valueType = tupleSchema.getFields().get((int)1).type;
                break block5;
            }
            if (input != null && input.getFields() != null) {
                for (int i = 0; i < input.size(); ++i) {
                    if (i % 2 != 1) continue;
                    if (valueType == null) {
                        valueType = input.getFields().get((int)i).type;
                        continue;
                    }
                    if (valueType == input.getFields().get((int)i).type) continue;
                    valueType = 50;
                    break;
                }
            }
        }
        Schema s = new Schema(new Schema.FieldSchema(null, 100));
        if (valueType != null && valueType != 50) {
            s.getFields().get((int)0).schema = new Schema(new Schema.FieldSchema(null, valueType));
            return s;
        }
        return s;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

