/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.streaming;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.pig.PigToStream;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.streaming.InputHandler;
import org.apache.pig.impl.streaming.StreamingCommand;

public class FileInputHandler
extends InputHandler {
    OutputStream fileOutStream;

    public FileInputHandler(StreamingCommand.HandleSpec handleSpec) throws ExecException {
        String fileName = handleSpec.name;
        this.serializer = (PigToStream)PigContext.instantiateFuncFromSpec(handleSpec.spec);
        try {
            this.fileOutStream = new FileOutputStream(new File(fileName));
            super.bindTo(this.fileOutStream);
        }
        catch (IOException fnfe) {
            int errCode = 2046;
            String msg = "Unable to create FileInputHandler.";
            throw new ExecException(msg, errCode, 4, fnfe);
        }
    }

    @Override
    public InputHandler.InputType getInputType() {
        return InputHandler.InputType.ASYNCHRONOUS;
    }

    @Override
    public void bindTo(OutputStream os) throws IOException {
        throw new UnsupportedOperationException("Cannot call bindTo on FileInputHandler");
    }

    @Override
    public synchronized void close(Process process) throws IOException {
        super.close(process);
        if (this.fileOutStream != null) {
            this.fileOutStream.flush();
            this.fileOutStream.close();
            this.fileOutStream = null;
        }
    }
}

