/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.DelayingRunner;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestDelayingRunner {
    private static final TableName DUMMY_TABLE = TableName.valueOf((String)"DUMMY_TABLE");
    private static final byte[] DUMMY_BYTES_1 = "DUMMY_BYTES_1".getBytes();
    private static final byte[] DUMMY_BYTES_2 = "DUMMY_BYTES_2".getBytes();
    private static HRegionInfo hri1 = new HRegionInfo(DUMMY_TABLE, DUMMY_BYTES_1, DUMMY_BYTES_2, false, 1L);

    @Test
    public void testDelayingRunner() throws Exception {
        MultiAction ma = new MultiAction();
        ma.add(hri1.getRegionName(), new Action((Row)new Put(DUMMY_BYTES_1), 0));
        final AtomicLong endTime = new AtomicLong();
        long sleepTime = 1000L;
        DelayingRunner runner = new DelayingRunner(1000L, ma.actions.entrySet().iterator().next());
        runner.setRunner(new Runnable(){

            @Override
            public void run() {
                endTime.set(EnvironmentEdgeManager.currentTime());
            }
        });
        long startTime = EnvironmentEdgeManager.currentTime();
        runner.run();
        long delay = endTime.get() - startTime;
        Assert.assertTrue((String)"DelayingRunner did not delay long enough", (delay >= 1000L ? 1 : 0) != 0);
        Assert.assertFalse((String)"DelayingRunner delayed too long", ((double)delay > 1200.0 ? 1 : 0) != 0);
    }
}

