/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPutDotHas {
    public static final byte[] ROW_01 = Bytes.toBytes((String)"row-01");
    public static final byte[] QUALIFIER_01 = Bytes.toBytes((String)"qualifier-01");
    public static final byte[] VALUE_01 = Bytes.toBytes((String)"value-01");
    public static final byte[] FAMILY_01 = Bytes.toBytes((String)"family-01");
    public static final long TS = 1234567L;
    public Put put = new Put(ROW_01);

    @Before
    public void setUp() {
        this.put.add(FAMILY_01, QUALIFIER_01, 1234567L, VALUE_01);
    }

    @Test
    public void testHasIgnoreValueIgnoreTS() {
        Assert.assertTrue((boolean)this.put.has(FAMILY_01, QUALIFIER_01));
        Assert.assertFalse((boolean)this.put.has(QUALIFIER_01, FAMILY_01));
    }

    @Test
    public void testHasIgnoreValue() {
        Assert.assertTrue((boolean)this.put.has(FAMILY_01, QUALIFIER_01, 1234567L));
        Assert.assertFalse((boolean)this.put.has(FAMILY_01, QUALIFIER_01, 1234568L));
    }

    @Test
    public void testHasIgnoreTS() {
        Assert.assertTrue((boolean)this.put.has(FAMILY_01, QUALIFIER_01, VALUE_01));
        Assert.assertFalse((boolean)this.put.has(FAMILY_01, VALUE_01, QUALIFIER_01));
    }

    @Test
    public void testHas() {
        Assert.assertTrue((boolean)this.put.has(FAMILY_01, QUALIFIER_01, 1234567L, VALUE_01));
        Assert.assertFalse((boolean)this.put.has(FAMILY_01, QUALIFIER_01, 1234568L, VALUE_01));
        Assert.assertFalse((boolean)this.put.has(FAMILY_01, QUALIFIER_01, 1234567L, QUALIFIER_01));
        Assert.assertFalse((boolean)this.put.has(QUALIFIER_01, QUALIFIER_01, 1234567L, VALUE_01));
        Assert.assertFalse((boolean)this.put.has(FAMILY_01, FAMILY_01, 1234567L, VALUE_01));
    }
}

