/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;

@InterfaceAudience.Private
public class MergeNormalizationPlan
implements NormalizationPlan {
    private static final Log LOG = LogFactory.getLog((String)MergeNormalizationPlan.class.getName());
    private final HRegionInfo firstRegion;
    private final HRegionInfo secondRegion;

    public MergeNormalizationPlan(HRegionInfo firstRegion, HRegionInfo secondRegion) {
        this.firstRegion = firstRegion;
        this.secondRegion = secondRegion;
    }

    HRegionInfo getFirstRegion() {
        return this.firstRegion;
    }

    HRegionInfo getSecondRegion() {
        return this.secondRegion;
    }

    public String toString() {
        return "MergeNormalizationPlan{firstRegion=" + this.firstRegion + ", secondRegion=" + this.secondRegion + '}';
    }

    @Override
    public void execute(Admin admin) {
        LOG.info((Object)("Executing merging normalization plan: " + this));
        try {
            admin.mergeRegions(this.firstRegion.getEncodedNameAsBytes(), this.secondRegion.getEncodedNameAsBytes(), true);
        }
        catch (IOException ex) {
            LOG.error((Object)"Error during region merge: ", (Throwable)ex);
        }
    }
}

