/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.accumulo.trace.instrument.Sampler;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;

public class TraceProxy {
    static final Sampler ALWAYS = new Sampler(){

        @Override
        public boolean next() {
            return true;
        }
    };

    public static <T> T trace(T instance) {
        return TraceProxy.trace(instance, ALWAYS);
    }

    public static <T> T trace(final T instance, final Sampler sampler) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
                if (!sampler.next()) {
                    return method.invoke(instance, args);
                }
                Span span2 = Trace.on(method.getName());
                try {
                    Object object = method.invoke(instance, args);
                    return object;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    throw ex;
                }
                finally {
                    span2.stop();
                }
            }
        };
        return (T)Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance.getClass().getInterfaces(), handler);
    }
}

