/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

class TableConfWatcher
implements Watcher {
    private static final Logger log;
    private Instance instance = null;

    TableConfWatcher(Instance instance) {
        this.instance = instance;
    }

    public void process(WatchedEvent event) {
        String path = event.getPath();
        if (log.isTraceEnabled()) {
            log.trace((Object)("WatchEvent : " + path + " " + event.getState() + " " + event.getType()));
        }
        String tablesPrefix = ZooUtil.getRoot((Instance)this.instance) + "/tables" + "/";
        String tableId = null;
        String key = null;
        if (path != null) {
            if (path.startsWith(tablesPrefix) && (tableId = path.substring(tablesPrefix.length())).contains("/")) {
                tableId = tableId.substring(0, tableId.indexOf(47));
                if (path.startsWith(tablesPrefix + tableId + "/conf" + "/")) {
                    key = path.substring((tablesPrefix + tableId + "/conf" + "/").length());
                }
            }
            if (tableId == null) {
                log.warn((Object)("Zookeeper told me about a path I was not watching " + path + " state=" + event.getState() + " type=" + event.getType()));
                return;
            }
        }
        block0 : switch (event.getType()) {
            case NodeDataChanged: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("EventNodeDataChanged " + event.getPath()));
                }
                if (key == null) break;
                ServerConfiguration.getTableConfiguration(this.instance, tableId).propertyChanged(key);
                break;
            }
            case NodeChildrenChanged: {
                ServerConfiguration.getTableConfiguration(this.instance, tableId).propertiesChanged(key);
                break;
            }
            case NodeDeleted: {
                if (key != null) break;
                ServerConfiguration.removeTableIdInstance(tableId);
                break;
            }
            case None: {
                switch (event.getState()) {
                    case Expired: {
                        ServerConfiguration.expireAllTableObservers();
                        break block0;
                    }
                    case SyncConnected: {
                        break block0;
                    }
                    case Disconnected: {
                        break block0;
                    }
                }
                log.warn((Object)("EventNone event not handled path = " + event.getPath() + " state=" + event.getState()));
                break;
            }
            case NodeCreated: {
                switch (event.getState()) {
                    case SyncConnected: {
                        break block0;
                    }
                }
                log.warn((Object)("Event NodeCreated event not handled path = " + event.getPath() + " state=" + event.getState()));
                break;
            }
            default: {
                log.warn((Object)("Event not handled path = " + event.getPath() + " state=" + event.getState() + " type = " + event.getType()));
            }
        }
    }

    static {
        Logger.getLogger((String)"org.apache.zookeeper").setLevel(Level.WARN);
        Logger.getLogger((String)"org.apache.hadoop.io.compress").setLevel(Level.WARN);
        log = Logger.getLogger(TableConfWatcher.class);
    }
}

