/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.transport.TTransportException;

public abstract class TabletBalancer {
    private static final Logger log = Logger.getLogger(TabletBalancer.class);
    protected ServerConfiguration configuration;

    public void init(ServerConfiguration conf) {
        this.configuration = conf;
    }

    public abstract void getAssignments(SortedMap<TServerInstance, TabletServerStatus> var1, Map<KeyExtent, TServerInstance> var2, Map<KeyExtent, TServerInstance> var3);

    public abstract long balance(SortedMap<TServerInstance, TabletServerStatus> var1, Set<KeyExtent> var2, List<TabletMigration> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TabletStats> getOnlineTabletsForTable(TServerInstance tserver, String tableId) throws ThriftSecurityException, TException {
        log.debug((Object)("Scanning tablet server " + tserver + " for table " + tableId));
        TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (InetSocketAddress)tserver.getLocation(), (AccumuloConfiguration)this.configuration.getConfiguration());
        try {
            List onlineTabletsForTable;
            List list = onlineTabletsForTable = client.getTabletStats(Tracer.traceInfo(), SecurityConstants.getSystemCredentials(), tableId);
            return list;
        }
        catch (TTransportException e) {
            log.error((Object)("Unable to connect to " + tserver + ": " + (Object)((Object)e)));
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)client);
        }
        return null;
    }

    public static List<TabletMigration> checkMigrationSanity(Set<TServerInstance> current, List<TabletMigration> migrations) {
        ArrayList<TabletMigration> result = new ArrayList<TabletMigration>(migrations.size());
        for (TabletMigration m : migrations) {
            if (m.tablet == null) {
                log.warn((Object)("Balancer gave back a null tablet " + m));
                continue;
            }
            if (m.newServer == null) {
                log.warn((Object)("Balancer did not set the destination " + m));
                continue;
            }
            if (m.oldServer == null) {
                log.warn((Object)("Balancer did not set the source " + m));
                continue;
            }
            if (!current.contains(m.oldServer)) {
                log.warn((Object)("Balancer wants to move a tablet from a server that is not current: " + m));
                continue;
            }
            if (!current.contains(m.newServer)) {
                log.warn((Object)("Balancer wants to move a tablet to a server that is not current: " + m));
                continue;
            }
            result.add(m);
        }
        return result;
    }
}

