/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.state.tables.TableManager;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.TableInfo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.log4j.Logger;

class FinishCreateTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableInfo tableInfo;

    public FinishCreateTable(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        TableManager.getInstance().transitionTableState(this.tableInfo.tableId, TableState.ONLINE);
        Utils.unreserveTable(this.tableInfo.tableId, tid, true);
        env.getEventCoordinator().event("Created table %s ", this.tableInfo.tableName);
        Logger.getLogger(FinishCreateTable.class).debug((Object)("Created table " + this.tableInfo.tableId + " " + this.tableInfo.tableName));
        return null;
    }

    @Override
    public String getReturn() {
        return this.tableInfo.tableId;
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
    }
}

