/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.server.security.handler.ZKSecurityTool;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

public final class ZKAuthenticator
implements Authenticator {
    static final Logger log = Logger.getLogger(ZKAuthenticator.class);
    private static Authenticator zkAuthenticatorInstance = null;
    private String ZKUserPath;
    private final ZooCache zooCache = new ZooCache();

    public static synchronized Authenticator getInstance() {
        if (zkAuthenticatorInstance == null) {
            zkAuthenticatorInstance = new ZKAuthenticator();
        }
        return zkAuthenticatorInstance;
    }

    @Override
    public void initialize(String instanceId, boolean initialize) {
        this.ZKUserPath = "/accumulo/" + instanceId + "/users";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeSecurity(TCredentials credentials, String principal, byte[] token) throws AccumuloSecurityException {
        try {
            IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                this.zooCache.clear();
                if (zoo.exists(this.ZKUserPath)) {
                    zoo.recursiveDelete(this.ZKUserPath, ZooUtil.NodeMissingPolicy.SKIP);
                    log.info((Object)("Removed " + this.ZKUserPath + "/" + " from zookeeper"));
                }
                zoo.putPersistentData(this.ZKUserPath, principal.getBytes(), ZooUtil.NodeExistsPolicy.FAIL);
                this.constructUser(principal, ZKSecurityTool.createPass(token));
            }
        }
        catch (KeeperException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (AccumuloException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructUser(String user, byte[] pass) throws KeeperException, InterruptedException {
        ZooCache zooCache = this.zooCache;
        synchronized (zooCache) {
            this.zooCache.clear();
            IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
            zoo.putPrivatePersistentData(this.ZKUserPath + "/" + user, pass, ZooUtil.NodeExistsPolicy.FAIL);
        }
    }

    @Override
    public Set<String> listUsers() {
        return new TreeSet<String>(this.zooCache.getChildren(this.ZKUserPath));
    }

    @Override
    public void createUser(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        try {
            if (!(token instanceof PasswordToken)) {
                throw new AccumuloSecurityException(principal, SecurityErrorCode.INVALID_TOKEN);
            }
            PasswordToken pt = (PasswordToken)token;
            this.constructUser(principal, ZKSecurityTool.createPass(pt.getPassword()));
        }
        catch (KeeperException e) {
            if (e.code().equals((Object)KeeperException.Code.NODEEXISTS)) {
                throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_EXISTS, (Throwable)e);
            }
            throw new AccumuloSecurityException(principal, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (AccumuloException e) {
            log.error((Object)e, (Throwable)e);
            throw new AccumuloSecurityException(principal, SecurityErrorCode.DEFAULT_SECURITY_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropUser(String user) throws AccumuloSecurityException {
        try {
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                this.zooCache.clear();
                ZooReaderWriter.getRetryingInstance().recursiveDelete(this.ZKUserPath + "/" + user, ZooUtil.NodeMissingPolicy.FAIL);
            }
        }
        catch (InterruptedException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (KeeperException e) {
            if (e.code().equals((Object)KeeperException.Code.NONODE)) {
                throw new AccumuloSecurityException(user, SecurityErrorCode.USER_DOESNT_EXIST, (Throwable)e);
            }
            log.error((Object)e, (Throwable)e);
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePassword(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        block9: {
            if (!(token instanceof PasswordToken)) {
                throw new AccumuloSecurityException(principal, SecurityErrorCode.INVALID_TOKEN);
            }
            PasswordToken pt = (PasswordToken)token;
            if (this.userExists(principal)) {
                try {
                    ZooCache zooCache = this.zooCache;
                    synchronized (zooCache) {
                        this.zooCache.clear(this.ZKUserPath + "/" + principal);
                        ZooReaderWriter.getRetryingInstance().putPrivatePersistentData(this.ZKUserPath + "/" + principal, ZKSecurityTool.createPass(pt.getPassword()), ZooUtil.NodeExistsPolicy.OVERWRITE);
                        break block9;
                    }
                }
                catch (KeeperException e) {
                    log.error((Object)e, (Throwable)e);
                    throw new AccumuloSecurityException(principal, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
                }
                catch (InterruptedException e) {
                    log.error((Object)e, (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (AccumuloException e) {
                    log.error((Object)e, (Throwable)e);
                    throw new AccumuloSecurityException(principal, SecurityErrorCode.DEFAULT_SECURITY_ERROR, (Throwable)e);
                }
            }
            throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_DOESNT_EXIST);
        }
    }

    @Override
    public boolean userExists(String user) {
        return this.zooCache.get(this.ZKUserPath + "/" + user) != null;
    }

    @Override
    public boolean validSecurityHandlers(Authorizor auth, PermissionHandler pm) {
        return true;
    }

    @Override
    public boolean authenticateUser(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        if (!(token instanceof PasswordToken)) {
            throw new AccumuloSecurityException(principal, SecurityErrorCode.INVALID_TOKEN);
        }
        PasswordToken pt = (PasswordToken)token;
        String zpath = this.ZKUserPath + "/" + principal;
        byte[] pass = this.zooCache.get(zpath);
        boolean result = ZKSecurityTool.checkPass(pt.getPassword(), pass);
        if (!result) {
            this.zooCache.clear(zpath);
            pass = this.zooCache.get(zpath);
            result = ZKSecurityTool.checkPass(pt.getPassword(), pass);
        }
        return result;
    }

    @Override
    public Set<Class<? extends AuthenticationToken>> getSupportedTokenTypes() {
        HashSet<Class<? extends AuthenticationToken>> cs = new HashSet<Class<? extends AuthenticationToken>>();
        cs.add(PasswordToken.class);
        return cs;
    }

    @Override
    public boolean validTokenClass(String tokenClass) {
        return tokenClass.equals(PasswordToken.class.getCanonicalName());
    }
}

