/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.master.state.tables.TableManager;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.log4j.Logger;

public class FindOfflineTablets {
    private static final Logger log = Logger.getLogger(FindOfflineTablets.class);

    public static void main(String[] args) throws Exception {
        ClientOpts opts = new ClientOpts();
        opts.parseArgs(FindOfflineTablets.class.getName(), args, new Object[0]);
        final AtomicBoolean scanning = new AtomicBoolean(false);
        Instance instance = opts.getInstance();
        MetaDataTableScanner rootScanner = new MetaDataTableScanner(instance, SecurityConstants.getSystemCredentials(), Constants.METADATA_ROOT_TABLET_KEYSPACE);
        MetaDataTableScanner metaScanner = new MetaDataTableScanner(instance, SecurityConstants.getSystemCredentials(), Constants.NON_ROOT_METADATA_KEYSPACE);
        IteratorChain scanner = new IteratorChain((Iterator)rootScanner, (Iterator)metaScanner);
        LiveTServerSet tservers = new LiveTServerSet(instance, (AccumuloConfiguration)DefaultConfiguration.getDefaultConfiguration(), new LiveTServerSet.Listener(){

            @Override
            public void update(LiveTServerSet current, Set<TServerInstance> deleted, Set<TServerInstance> added) {
                if (!deleted.isEmpty() && scanning.get()) {
                    log.warn((Object)("Tablet servers deleted while scanning: " + deleted));
                }
                if (!added.isEmpty() && scanning.get()) {
                    log.warn((Object)("Tablet servers added while scanning: " + added));
                }
            }
        });
        tservers.startListeningForTabletServerChanges();
        scanning.set(true);
        while (scanner.hasNext()) {
            TabletLocationState locationState = (TabletLocationState)scanner.next();
            TabletState state = locationState.getState(tservers.getCurrentServers());
            if (state == null || state == TabletState.HOSTED || TableManager.getInstance().getTableState(locationState.extent.getTableId().toString()) == TableState.OFFLINE || locationState.extent.equals((Object)Constants.ROOT_TABLET_EXTENT)) continue;
            System.out.println(locationState + " is " + (Object)((Object)state) + "  #walogs:" + locationState.walogs.size());
        }
    }
}

