/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.util;

import alluxio.ClientContext;
import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.block.AllMastersWorkerInfo;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.RetryHandlingBlockMasterClient;
import alluxio.client.block.options.GetWorkerReportOptions;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterClientContext;
import alluxio.retry.TimeoutRetry;
import alluxio.util.ConfigurationUtils;
import alluxio.wire.WorkerInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerInfoUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerInfoUtil.class);
    private static final int RETRY_TIMEOUT = 5000;
    private static final int RETRY_INTERVAL = 500;

    public static AllMastersWorkerInfo getWorkerReportsFromAllMasters(AlluxioConfiguration configuration, BlockMasterClient primaryMasterClient, GetWorkerReportOptions options) throws IOException {
        Preconditions.checkState((boolean)configuration.getBoolean(PropertyKey.WORKER_REGISTER_TO_ALL_MASTERS), (Object)"GetWorkerReportsFromAllMasters is used to collect worker info from all masters, including standby masters. This method requires worker all master registration to be enabled.");
        Preconditions.checkState((boolean)options.getFieldRange().contains((Object)GetWorkerReportOptions.WorkerInfoField.ID));
        Preconditions.checkState((boolean)options.getFieldRange().contains((Object)GetWorkerReportOptions.WorkerInfoField.STATE));
        Preconditions.checkState((boolean)options.getFieldRange().contains((Object)GetWorkerReportOptions.WorkerInfoField.ADDRESS));
        ClientContext clientContext = ClientContext.create((AlluxioConfiguration)Configuration.global());
        MasterClientContext masterContext = MasterClientContext.newBuilder((ClientContext)clientContext).build();
        Preconditions.checkState((boolean)(primaryMasterClient.getRemoteSockAddress() instanceof InetSocketAddress));
        InetSocketAddress primaryMasterAddress = (InetSocketAddress)primaryMasterClient.getRemoteSockAddress();
        List masterAddresses = ConfigurationUtils.getMasterRpcAddresses((AlluxioConfiguration)configuration);
        Preconditions.checkState((boolean)masterAddresses.contains(primaryMasterAddress));
        HashMap<InetSocketAddress, List<WorkerInfo>> masterAddressToWorkerInfoMap = new HashMap<InetSocketAddress, List<WorkerInfo>>();
        for (InetSocketAddress masterAddress : masterAddresses) {
            try {
                RetryHandlingBlockMasterClient client = new RetryHandlingBlockMasterClient(masterContext, masterAddress, () -> new TimeoutRetry(5000L, 500));
                Throwable throwable = null;
                try {
                    List<WorkerInfo> workerInfos = client.getWorkerReport(options);
                    masterAddressToWorkerInfoMap.put(masterAddress, workerInfos);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (client == null) continue;
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    client.close();
                }
            }
            catch (Exception e) {
                if (masterAddress.equals(primaryMasterAddress)) {
                    LOG.error("Failed to get worker report from master: {}", (Object)masterContext, (Object)e);
                    throw e;
                }
                LOG.warn("Failed to get worker report from master: {}", (Object)masterContext, (Object)e);
            }
        }
        return WorkerInfoUtil.populateAllMastersWorkerInfo(primaryMasterAddress, masterAddressToWorkerInfoMap);
    }

    @VisibleForTesting
    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"})
    static AllMastersWorkerInfo populateAllMastersWorkerInfo(InetSocketAddress primaryMasterAddress, Map<InetSocketAddress, List<WorkerInfo>> masterAddressToWorkerInfoMap) {
        HashMap<Long, List<Pair<InetSocketAddress, WorkerInfo>>> workerIdInfoMap = new HashMap<Long, List<Pair<InetSocketAddress, WorkerInfo>>>();
        HashMap<Long, InetSocketAddress> workerIdAddressMap = new HashMap<Long, InetSocketAddress>();
        List<WorkerInfo> workerInfosFromPrimaryMaster = null;
        for (InetSocketAddress masterAddress : masterAddressToWorkerInfoMap.keySet()) {
            List<WorkerInfo> workerInfo = masterAddressToWorkerInfoMap.get(masterAddress);
            if (masterAddress.equals(primaryMasterAddress)) {
                workerInfosFromPrimaryMaster = workerInfo;
            }
            for (WorkerInfo info : workerInfo) {
                workerIdInfoMap.compute(info.getId(), (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<Pair>();
                    }
                    v.add(new Pair((Object)masterAddress, (Object)info));
                    return v;
                });
                workerIdAddressMap.compute(info.getId(), (k, v) -> {
                    InetSocketAddress workerAddress = InetSocketAddress.createUnresolved(info.getAddress().getHost(), info.getAddress().getRpcPort());
                    if (v == null) {
                        return workerAddress;
                    }
                    if (!v.equals(workerAddress)) {
                        throw new RuntimeException(String.format("The same worker id %d corresponds to multiple worker name %s %s", k, v, workerAddress));
                    }
                    return v;
                });
            }
        }
        return new AllMastersWorkerInfo(workerIdAddressMap, new ArrayList<InetSocketAddress>(masterAddressToWorkerInfoMap.keySet()), primaryMasterAddress, workerInfosFromPrimaryMaster, workerIdInfoMap);
    }
}

