/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.file.FileSystemMasterClient;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterClientContext;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.resource.DynamicResourcePool;
import alluxio.util.ThreadFactoryUtils;
import com.codahale.metrics.Counter;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FileSystemMasterClientPool
extends DynamicResourcePool<FileSystemMasterClient> {
    private final MasterClientContext mMasterContext;
    private final long mGcThresholdMs;
    private static final int FS_MASTER_CLIENT_POOL_GC_THREADPOOL_SIZE = 1;
    private static final ScheduledExecutorService GC_EXECUTOR = new ScheduledThreadPoolExecutor(1, ThreadFactoryUtils.build((String)"FileSystemMasterClientPoolGcThreads-%d", (boolean)true));
    private static final Counter COUNTER = MetricsSystem.counter((String)MetricKey.CLIENT_FILE_SYSTEM_MASTER_CLIENT_COUNT.getName());

    public FileSystemMasterClientPool(MasterClientContext ctx) {
        super(DynamicResourcePool.Options.defaultOptions().setMinCapacity(ctx.getClusterConf().getInt(PropertyKey.USER_FILE_MASTER_CLIENT_POOL_SIZE_MIN)).setMaxCapacity(ctx.getClusterConf().getInt(PropertyKey.USER_FILE_MASTER_CLIENT_POOL_SIZE_MAX)).setGcIntervalMs(ctx.getClusterConf().getMs(PropertyKey.USER_FILE_MASTER_CLIENT_POOL_GC_INTERVAL_MS)).setGcExecutor(GC_EXECUTOR));
        this.mMasterContext = ctx;
        this.mGcThresholdMs = ctx.getClusterConf().getMs(PropertyKey.USER_FILE_MASTER_CLIENT_POOL_GC_THRESHOLD_MS);
    }

    protected void closeResource(FileSystemMasterClient client) {
        try {
            client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected FileSystemMasterClient createNewResource() {
        return FileSystemMasterClient.Factory.create(this.mMasterContext);
    }

    protected boolean isHealthy(FileSystemMasterClient client) {
        return client.isConnected();
    }

    protected Counter getMetricCounter() {
        return COUNTER;
    }

    protected boolean shouldGc(DynamicResourcePool.ResourceInternal<FileSystemMasterClient> clientResourceInternal) {
        return System.currentTimeMillis() - clientResourceInternal.getLastAccessTimeMs() > this.mGcThresholdMs;
    }
}

