/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.evictor;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.evictor.CacheEvictorOptions;
import alluxio.client.file.cache.evictor.LRUCacheEvictor;
import alluxio.client.file.cache.evictor.NondeterministicLRUCacheEvictor;
import alluxio.util.CommonUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface CacheEvictor {
    public static CacheEvictor create(CacheEvictorOptions options) {
        if (options.isNondeterministic() && options.getEvictorClass().equals(LRUCacheEvictor.class)) {
            return new NondeterministicLRUCacheEvictor(options);
        }
        return (CacheEvictor)CommonUtils.createNewClassInstance(options.getEvictorClass(), (Class[])new Class[]{CacheEvictorOptions.class}, (Object[])new Object[]{options});
    }

    public void updateOnGet(PageId var1);

    public void updateOnPut(PageId var1);

    public void updateOnDelete(PageId var1);

    @Nullable
    public PageId evict();

    @Nullable
    public PageId evictMatching(Predicate<PageId> var1);

    public void reset();
}

