/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.meta;

import alluxio.AbstractMasterClient;
import alluxio.client.meta.MetaMasterClient;
import alluxio.grpc.BackupPRequest;
import alluxio.grpc.BackupPStatus;
import alluxio.grpc.BackupStatusPRequest;
import alluxio.grpc.CheckpointPOptions;
import alluxio.grpc.ConfigCheckReport;
import alluxio.grpc.GetConfigReportPOptions;
import alluxio.grpc.GetMasterInfoPOptions;
import alluxio.grpc.ListProxyStatusPRequest;
import alluxio.grpc.MasterInfo;
import alluxio.grpc.MasterInfoField;
import alluxio.grpc.MetaMasterClientServiceGrpc;
import alluxio.grpc.ProxyStatus;
import alluxio.grpc.ServiceType;
import alluxio.master.MasterClientContext;
import alluxio.wire.BackupStatus;
import io.grpc.Channel;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RetryHandlingMetaMasterClient
extends AbstractMasterClient
implements MetaMasterClient {
    private static final Logger RPC_LOG = LoggerFactory.getLogger(MetaMasterClient.class);
    private MetaMasterClientServiceGrpc.MetaMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingMetaMasterClient(MasterClientContext conf) {
        super(conf);
    }

    protected ServiceType getRemoteServiceType() {
        return ServiceType.META_MASTER_CLIENT_SERVICE;
    }

    protected String getServiceName() {
        return "MetaMaster";
    }

    protected long getServiceVersion() {
        return 2L;
    }

    protected void afterConnect() {
        this.mClient = MetaMasterClientServiceGrpc.newBlockingStub((Channel)this.mChannel);
    }

    @Override
    public BackupStatus backup(BackupPRequest backupRequest) throws IOException {
        return (BackupStatus)this.retryRPC(() -> BackupStatus.fromProto((BackupPStatus)this.mClient.backup(backupRequest)), RPC_LOG, "Backup", "backupRequest=%s", new Object[]{backupRequest});
    }

    @Override
    public BackupStatus getBackupStatus(UUID backupId) throws IOException {
        return (BackupStatus)this.retryRPC(() -> BackupStatus.fromProto((BackupPStatus)this.mClient.getBackupStatus(BackupStatusPRequest.newBuilder().setBackupId(backupId.toString()).build())), RPC_LOG, "GetBackupStatus", "backupId=%s", new Object[]{backupId});
    }

    @Override
    public alluxio.wire.ConfigCheckReport getConfigReport() throws IOException {
        return (alluxio.wire.ConfigCheckReport)this.retryRPC(() -> alluxio.wire.ConfigCheckReport.fromProto((ConfigCheckReport)this.mClient.getConfigReport(GetConfigReportPOptions.getDefaultInstance()).getReport()), RPC_LOG, "GetConfigReport", "", new Object[0]);
    }

    @Override
    public MasterInfo getMasterInfo(Set<MasterInfoField> fields) throws IOException {
        return (MasterInfo)this.retryRPC(() -> this.mClient.getMasterInfo(GetMasterInfoPOptions.newBuilder().addAllFilter((Iterable)fields).build()).getMasterInfo(), RPC_LOG, "GetMasterInfo", "fields=%s", new Object[]{fields});
    }

    @Override
    public String checkpoint() throws IOException {
        return (String)this.retryRPC(() -> this.mClient.checkpoint(CheckpointPOptions.newBuilder().build()).getMasterHostname(), RPC_LOG, "Checkpoint", "", new Object[0]);
    }

    @Override
    public List<ProxyStatus> listProxyStatus() throws IOException {
        return (List)this.retryRPC(() -> this.mClient.listProxyStatus(ListProxyStatusPRequest.getDefaultInstance()).getProxyStatusesList(), RPC_LOG, "ListProxyStatus", "", new Object[0]);
    }
}

