/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ConcurrentIdentityHashMap<K, V>
implements ConcurrentMap<K, V> {
    private static final String UNSUPPORTED_OP_FMT = "%s is not supported in this set returned from " + ConcurrentIdentityHashMap.class.getCanonicalName();
    private final ConcurrentHashMap<IdentityObject<K>, V> mInternalMap;

    public ConcurrentIdentityHashMap() {
        this.mInternalMap = new ConcurrentHashMap();
    }

    public ConcurrentIdentityHashMap(int initialCapacity) {
        this.mInternalMap = new ConcurrentHashMap(initialCapacity);
    }

    public ConcurrentIdentityHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1);
    }

    public ConcurrentIdentityHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.mInternalMap = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public boolean containsKey(Object k) {
        return this.mInternalMap.containsKey(new IdentityObject<Object>(k));
    }

    @Override
    public V put(K k, V v) {
        return this.mInternalMap.put(new IdentityObject<K>(k), v);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        return this.mInternalMap.putIfAbsent(new IdentityObject<K>(k), v);
    }

    @Override
    public boolean remove(Object k, Object v) {
        return this.mInternalMap.remove(new IdentityObject<Object>(k), v);
    }

    @Override
    public V remove(Object k) {
        return this.mInternalMap.remove(new IdentityObject<Object>(k));
    }

    @Override
    public boolean replace(K k, V v1, V v2) {
        return this.mInternalMap.replace(new IdentityObject<K>(k), v1, v2);
    }

    @Override
    public V replace(K k, V v) {
        return this.mInternalMap.replace(new IdentityObject<K>(k), v);
    }

    @Override
    public V get(Object k) {
        return this.mInternalMap.get(new IdentityObject<Object>(k));
    }

    @Override
    public Collection<V> values() {
        return this.mInternalMap.values();
    }

    @Override
    public void clear() {
        this.mInternalMap.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mInternalMap.entrySet().stream().map(x$0 -> new IdentityEntry(x$0)).collect(Collectors.toSet());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        map.forEach((k, v) -> this.mInternalMap.put(new IdentityObject<Object>(k), v));
    }

    @Override
    public boolean isEmpty() {
        return this.mInternalMap.isEmpty();
    }

    @Override
    public int size() {
        return this.mInternalMap.size();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mInternalMap.containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        final Set set = this.mInternalMap.keySet();
        return new Set<K>(){

            @Override
            public int size() {
                return set.size();
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return set.contains(new IdentityObject<Object>(o));
            }

            @Override
            public Iterator<K> iterator() {
                return set.stream().map(IdentityObject::get).iterator();
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException(String.format(UNSUPPORTED_OP_FMT, "toArray"));
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException(String.format(UNSUPPORTED_OP_FMT, "toArray"));
            }

            @Override
            public boolean add(K k) {
                throw new UnsupportedOperationException(String.format(UNSUPPORTED_OP_FMT, "add"));
            }

            @Override
            public boolean remove(Object o) {
                return set.remove(new IdentityObject<Object>(o));
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException(String.format(UNSUPPORTED_OP_FMT, "containsAll"));
            }

            @Override
            public boolean addAll(Collection<? extends K> c) {
                throw new UnsupportedOperationException(String.format(UNSUPPORTED_OP_FMT, "addAll"));
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException(String.format(UNSUPPORTED_OP_FMT, "retainAll"));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException(String.format(UNSUPPORTED_OP_FMT, "removeAll"));
            }

            @Override
            public void clear() {
                set.clear();
            }
        };
    }

    private class IdentityEntry<T, P>
    implements Map.Entry<T, P> {
        private final IdentityObject<T> mKey;
        private P mValue;

        IdentityEntry(Map.Entry<IdentityObject<T>, P> e) {
            this.mKey = e.getKey();
            this.mValue = e.getValue();
        }

        @Override
        public T getKey() {
            return this.mKey.get();
        }

        @Override
        public P getValue() {
            return this.mValue;
        }

        @Override
        public P setValue(P v) {
            P old = this.mValue;
            this.mValue = v;
            return old;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.mKey, this.mValue);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IdentityEntry)) {
                return false;
            }
            try {
                IdentityEntry other = (IdentityEntry)o;
                return this.mKey.equals(other.mKey) && this.mValue.equals(other.mValue);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }

    private class IdentityObject<T> {
        private T mObj;

        public IdentityObject(T o) {
            this.mObj = o;
        }

        public T get() {
            return this.mObj;
        }

        public int hashCode() {
            int a = System.identityHashCode(this.mObj);
            a = a + 2127912214 + (a << 12);
            a = a ^ 0xC761C23C ^ a >> 19;
            a = a + 374761393 + (a << 5);
            a = a + -744332180 ^ a << 9;
            a = a + -42973499 + (a << 3);
            a = a ^ 0xB55A4F09 ^ a >> 16;
            return a;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IdentityObject)) {
                return false;
            }
            try {
                IdentityObject other = (IdentityObject)o;
                return this.mObj == other.mObj;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }
}

