/*
 * Decompiled with CFR 0.152.
 */
package alluxio.concurrent;

import alluxio.AlluxioURI;
import alluxio.SyncInfo;
import alluxio.collections.Pair;
import alluxio.concurrent.ForkJoinPoolHelper;
import alluxio.concurrent.jsr.ForkJoinPool;
import alluxio.conf.AlluxioConfiguration;
import alluxio.file.options.DescendantType;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.underfs.Fingerprint;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsLoadResult;
import alluxio.underfs.UfsMode;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.FileLocationOptions;
import alluxio.underfs.options.GetFileStatusOptions;
import alluxio.underfs.options.ListOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.RateLimiter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class ManagedBlockingUfsForwarder
implements UnderFileSystem {
    private UnderFileSystem mUfs;

    public ManagedBlockingUfsForwarder(UnderFileSystem ufs) {
        this.mUfs = ufs;
    }

    @Override
    public void cleanup() throws IOException {
        this.mUfs.cleanup();
    }

    @Override
    public void connectFromMaster(String hostname) throws IOException {
        this.mUfs.connectFromMaster(hostname);
    }

    @Override
    public void connectFromWorker(String hostname) throws IOException {
        this.mUfs.connectFromWorker(hostname);
    }

    @Override
    public OutputStream create(final String path) throws IOException {
        return (OutputStream)new ManagedBlockingUfsMethod<OutputStream>(){

            @Override
            public OutputStream execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.create(path);
            }
        }.get();
    }

    @Override
    public OutputStream create(final String path, final CreateOptions options) throws IOException {
        return (OutputStream)new ManagedBlockingUfsMethod<OutputStream>(){

            @Override
            public OutputStream execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.create(path, options);
            }
        }.get();
    }

    @Override
    public OutputStream createNonexistingFile(final String path) throws IOException {
        return (OutputStream)new ManagedBlockingUfsMethod<OutputStream>(){

            @Override
            public OutputStream execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.createNonexistingFile(path);
            }
        }.get();
    }

    @Override
    public OutputStream createNonexistingFile(final String path, final CreateOptions options) throws IOException {
        return (OutputStream)new ManagedBlockingUfsMethod<OutputStream>(){

            @Override
            public OutputStream execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.createNonexistingFile(path, options);
            }
        }.get();
    }

    @Override
    public boolean deleteDirectory(final String path) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.deleteDirectory(path);
            }
        }.get();
    }

    @Override
    public boolean deleteDirectory(final String path, final DeleteOptions options) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.deleteDirectory(path, options);
            }
        }.get();
    }

    @Override
    public boolean deleteExistingDirectory(final String path) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.deleteExistingDirectory(path);
            }
        }.get();
    }

    @Override
    public boolean deleteExistingDirectory(final String path, final DeleteOptions options) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.deleteExistingDirectory(path, options);
            }
        }.get();
    }

    @Override
    public boolean deleteFile(final String path) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.deleteFile(path);
            }
        }.get();
    }

    @Override
    public boolean deleteExistingFile(final String path) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.deleteExistingFile(path);
            }
        }.get();
    }

    @Override
    public boolean exists(final String path) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.exists(path);
            }
        }.get();
    }

    @Override
    public Pair<AccessControlList, DefaultAccessControlList> getAclPair(final String path) throws IOException {
        return (Pair)new ManagedBlockingUfsMethod<Pair<AccessControlList, DefaultAccessControlList>>(){

            @Override
            public Pair<AccessControlList, DefaultAccessControlList> execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.getAclPair(path);
            }
        }.get();
    }

    @Override
    public long getBlockSizeByte(final String path) throws IOException {
        return (Long)new ManagedBlockingUfsMethod<Long>(){

            @Override
            public Long execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.getBlockSizeByte(path);
            }
        }.get();
    }

    @Override
    public AlluxioConfiguration getConfiguration() throws IOException {
        return (AlluxioConfiguration)new ManagedBlockingUfsMethod<AlluxioConfiguration>(){

            @Override
            public AlluxioConfiguration execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.getConfiguration();
            }
        }.get();
    }

    @Override
    public UfsDirectoryStatus getDirectoryStatus(final String path) throws IOException {
        return (UfsDirectoryStatus)new ManagedBlockingUfsMethod<UfsDirectoryStatus>(){

            @Override
            public UfsDirectoryStatus execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.getDirectoryStatus(path);
            }
        }.get();
    }

    @Override
    public UfsDirectoryStatus getExistingDirectoryStatus(final String path) throws IOException {
        return (UfsDirectoryStatus)new ManagedBlockingUfsMethod<UfsDirectoryStatus>(){

            @Override
            public UfsDirectoryStatus execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.getExistingDirectoryStatus(path);
            }
        }.get();
    }

    @Override
    public List<String> getFileLocations(final String path) throws IOException {
        return (List)new ManagedBlockingUfsMethod<List<String>>(){

            @Override
            public List<String> execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.getFileLocations(path);
            }
        }.get();
    }

    @Override
    public List<String> getFileLocations(final String path, final FileLocationOptions options) throws IOException {
        return (List)new ManagedBlockingUfsMethod<List<String>>(){

            @Override
            public List<String> execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.getFileLocations(path, options);
            }
        }.get();
    }

    @Override
    public UfsFileStatus getFileStatus(final String path, GetFileStatusOptions options) throws IOException {
        return (UfsFileStatus)new ManagedBlockingUfsMethod<UfsFileStatus>(){

            @Override
            public UfsFileStatus execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.getFileStatus(path);
            }
        }.get();
    }

    @Override
    public UfsFileStatus getExistingFileStatus(final String path) throws IOException {
        return (UfsFileStatus)new ManagedBlockingUfsMethod<UfsFileStatus>(){

            @Override
            public UfsFileStatus execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.getExistingFileStatus(path);
            }
        }.get();
    }

    @Override
    public String getFingerprint(String path) {
        return this.mUfs.getFingerprint(path);
    }

    @Override
    public Fingerprint getParsedFingerprint(String path) {
        return this.mUfs.getParsedFingerprint(path);
    }

    @Override
    public Fingerprint getParsedFingerprint(String path, @Nullable String contentHash) {
        return this.mUfs.getParsedFingerprint(path, contentHash);
    }

    @Override
    public UfsMode getOperationMode(Map<String, UfsMode> physicalUfsState) {
        return this.mUfs.getOperationMode(physicalUfsState);
    }

    @Override
    public List<String> getPhysicalStores() {
        return this.mUfs.getPhysicalStores();
    }

    @Override
    public long getSpace(final String path, final UnderFileSystem.SpaceType type) throws IOException {
        return (Long)new ManagedBlockingUfsMethod<Long>(){

            @Override
            public Long execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.getSpace(path, type);
            }
        }.get();
    }

    @Override
    public UfsStatus getStatus(final String path) throws IOException {
        return (UfsStatus)new ManagedBlockingUfsMethod<UfsStatus>(){

            @Override
            public UfsStatus execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.getStatus(path);
            }
        }.get();
    }

    @Override
    public UfsStatus getExistingStatus(final String path) throws IOException {
        return (UfsStatus)new ManagedBlockingUfsMethod<UfsStatus>(){

            @Override
            public UfsStatus execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.getExistingStatus(path);
            }
        }.get();
    }

    @Override
    public String getUnderFSType() {
        return this.mUfs.getUnderFSType();
    }

    @Override
    public boolean isDirectory(final String path) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.isDirectory(path);
            }
        }.get();
    }

    @Override
    public boolean isExistingDirectory(final String path) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.isExistingDirectory(path);
            }
        }.get();
    }

    @Override
    public boolean isFile(final String path) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.isFile(path);
            }
        }.get();
    }

    @Override
    public boolean isObjectStorage() {
        return this.mUfs.isObjectStorage();
    }

    @Override
    public boolean isSeekable() {
        return this.mUfs.isSeekable();
    }

    @Override
    public UfsStatus[] listStatus(final String path) throws IOException {
        return (UfsStatus[])new ManagedBlockingUfsMethod<UfsStatus[]>(){

            @Override
            public UfsStatus[] execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.listStatus(path);
            }
        }.get();
    }

    @Override
    public UfsStatus[] listStatus(final String path, final ListOptions options) throws IOException {
        return (UfsStatus[])new ManagedBlockingUfsMethod<UfsStatus[]>(){

            @Override
            public UfsStatus[] execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.listStatus(path, options);
            }
        }.get();
    }

    @Override
    public boolean mkdirs(final String path) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.mkdirs(path);
            }
        }.get();
    }

    @Override
    public boolean mkdirs(final String path, final MkdirsOptions options) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.mkdirs(path, options);
            }
        }.get();
    }

    @Override
    public InputStream open(final String path) throws IOException {
        return (InputStream)new ManagedBlockingUfsMethod<InputStream>(){

            @Override
            public InputStream execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.open(path);
            }
        }.get();
    }

    @Override
    public InputStream open(final String path, final OpenOptions options) throws IOException {
        return (InputStream)new ManagedBlockingUfsMethod<InputStream>(){

            @Override
            public InputStream execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.open(path, options);
            }
        }.get();
    }

    @Override
    public InputStream openExistingFile(final String path) throws IOException {
        return (InputStream)new ManagedBlockingUfsMethod<InputStream>(){

            @Override
            public InputStream execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.openExistingFile(path);
            }
        }.get();
    }

    @Override
    public InputStream openExistingFile(final String path, final OpenOptions options) throws IOException {
        return (InputStream)new ManagedBlockingUfsMethod<InputStream>(){

            @Override
            public InputStream execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.openExistingFile(path, options);
            }
        }.get();
    }

    @Override
    public boolean renameDirectory(final String src, final String dst) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.renameDirectory(src, dst);
            }
        }.get();
    }

    @Override
    public boolean renameRenamableDirectory(final String src, final String dst) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.renameRenamableDirectory(src, dst);
            }
        }.get();
    }

    @Override
    public boolean renameFile(final String src, final String dst) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.renameFile(src, dst);
            }
        }.get();
    }

    @Override
    public boolean renameRenamableFile(final String src, final String dst) throws IOException {
        return (Boolean)new ManagedBlockingUfsMethod<Boolean>(){

            @Override
            public Boolean execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.renameRenamableFile(src, dst);
            }
        }.get();
    }

    @Override
    public AlluxioURI resolveUri(AlluxioURI ufsBaseUri, String alluxioPath) {
        return this.mUfs.resolveUri(ufsBaseUri, alluxioPath);
    }

    @Override
    public void setAclEntries(final String path, final List<AclEntry> aclEntries) throws IOException {
        new ManagedBlockingUfsMethod<Void>(){

            @Override
            public Void execute() throws IOException {
                ManagedBlockingUfsForwarder.this.mUfs.setAclEntries(path, aclEntries);
                return null;
            }
        }.get();
    }

    @Override
    public void setMode(final String path, final short mode) throws IOException {
        new ManagedBlockingUfsMethod<Void>(){

            @Override
            public Void execute() throws IOException {
                ManagedBlockingUfsForwarder.this.mUfs.setMode(path, mode);
                return null;
            }
        }.get();
    }

    @Override
    public void setOwner(final String path, final String owner, final String group) throws IOException {
        new ManagedBlockingUfsMethod<Void>(){

            @Override
            public Void execute() throws IOException {
                ManagedBlockingUfsForwarder.this.mUfs.setOwner(path, owner, group);
                return null;
            }
        }.get();
    }

    @Override
    public boolean supportsFlush() throws IOException {
        return this.mUfs.supportsFlush();
    }

    @Override
    public boolean supportsActiveSync() {
        return this.mUfs.supportsActiveSync();
    }

    @Override
    public SyncInfo getActiveSyncInfo() throws IOException {
        return this.mUfs.getActiveSyncInfo();
    }

    @Override
    public void startSync(AlluxioURI uri) throws IOException {
        this.mUfs.startSync(uri);
    }

    @Override
    public void stopSync(AlluxioURI uri) throws IOException {
        this.mUfs.stopSync(uri);
    }

    @Override
    public boolean startActiveSyncPolling(long txId) throws IOException {
        return this.mUfs.startActiveSyncPolling(txId);
    }

    @Override
    public boolean stopActiveSyncPolling() throws IOException {
        return this.mUfs.stopActiveSyncPolling();
    }

    @Override
    public void close() throws IOException {
        this.mUfs.close();
    }

    @Override
    public Iterator<UfsStatus> listStatusIterable(final String path, final ListOptions options, final String startAfter, final int batchSize) throws IOException {
        return (Iterator)new ManagedBlockingUfsMethod<Iterator<UfsStatus>>(){

            @Override
            public Iterator<UfsStatus> execute() throws IOException {
                return ManagedBlockingUfsForwarder.this.mUfs.listStatusIterable(path, options, startAfter, batchSize);
            }
        }.get();
    }

    @Override
    public void performListingAsync(String path, @Nullable String continuationToken, @Nullable String startAfter, DescendantType descendantType, boolean checkStatus, Consumer<UfsLoadResult> onComplete, Consumer<Throwable> onError) {
        this.mUfs.performListingAsync(path, continuationToken, startAfter, descendantType, checkStatus, onComplete, onError);
    }

    @Override
    public RateLimiter getRateLimiter() {
        return this.mUfs.getRateLimiter();
    }

    abstract class ManagedBlockingUfsMethod<T>
    implements ForkJoinPool.ManagedBlocker {
        private T mResult;
        private IOException mExc;

        ManagedBlockingUfsMethod() {
        }

        abstract T execute() throws IOException;

        public T get() throws IOException {
            try {
                ForkJoinPoolHelper.safeManagedBlock(this);
                if (this.mExc != null) {
                    throw this.mExc;
                }
                return this.mResult;
            }
            catch (InterruptedException exc) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted");
            }
        }

        @Override
        public boolean block() throws InterruptedException {
            try {
                this.mResult = this.execute();
            }
            catch (IOException exc) {
                this.mExc = exc;
            }
            return true;
        }

        @Override
        public boolean isReleasable() {
            return false;
        }
    }
}

