/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import com.google.common.base.MoreObjects;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class GrpcServerAddress {
    private SocketAddress mSocketAddress;
    private String mHostName;

    private GrpcServerAddress(String hostName, SocketAddress socketAddress) {
        this.mHostName = hostName;
        this.mSocketAddress = socketAddress;
    }

    public static GrpcServerAddress create(InetSocketAddress socketAddress) {
        return new GrpcServerAddress(socketAddress.getHostName(), socketAddress);
    }

    public static GrpcServerAddress create(String hostName, SocketAddress socketAddress) {
        return new GrpcServerAddress(hostName, socketAddress);
    }

    public String getHostName() {
        return this.mHostName;
    }

    public SocketAddress getSocketAddress() {
        return this.mSocketAddress;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.mHostName).append((Object)this.mSocketAddress).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GrpcServerAddress)) {
            return false;
        }
        GrpcServerAddress otherAddress = (GrpcServerAddress)other;
        return Objects.equals(this.mHostName, otherAddress.getHostName()) && Objects.equals(this.mSocketAddress, otherAddress.getSocketAddress());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("HostName", (Object)this.mHostName).add("SocketAddress", (Object)this.mSocketAddress).toString();
    }
}

