/*
 * Decompiled with CFR 0.152.
 */
package alluxio.recorder;

import alluxio.recorder.NoopRecorder;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.helpers.MessageFormatter;

@NotThreadSafe
public class Recorder {
    private static final int MAX_RECORDS_COUNT = 10000;
    private final LinkedList<String> mRecords = new LinkedList();

    public void record(String message) {
        this.mRecords.add(message);
        if (this.mRecords.size() > 10000) {
            this.mRecords.removeFirst();
        }
    }

    public void record(String format, Object ... arguments) {
        this.record(MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage());
    }

    public List<String> takeRecords() {
        ImmutableList records = ImmutableList.copyOf(this.mRecords);
        this.mRecords.clear();
        return records;
    }

    public static Recorder noopRecorder() {
        return NoopRecorder.INSTANCE;
    }
}

