/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.compression;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.util.compression.DirectoryMarshaller;
import alluxio.util.compression.TarUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;

public class TarGzMarshaller
implements DirectoryMarshaller {
    private final int mSnapshotCompressionLevel = Configuration.getInt(PropertyKey.MASTER_EMBEDDED_JOURNAL_SNAPSHOT_REPLICATION_COMPRESSION_LEVEL);

    @Override
    public long write(Path path, OutputStream outputStream) throws IOException, InterruptedException {
        return TarUtils.writeTarGz(path, outputStream, this.mSnapshotCompressionLevel);
    }

    @Override
    public long read(Path path, InputStream inputStream) throws IOException {
        return TarUtils.readTarGz(path, inputStream);
    }
}

