/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.io;

import alluxio.exception.InvalidPathException;
import alluxio.exception.runtime.AlreadyExistsRuntimeException;
import alluxio.exception.runtime.FailedPreconditionRuntimeException;
import alluxio.exception.runtime.InternalRuntimeException;
import alluxio.exception.runtime.InvalidArgumentRuntimeException;
import alluxio.exception.runtime.NotFoundRuntimeException;
import alluxio.exception.runtime.PermissionDeniedRuntimeException;
import alluxio.exception.runtime.UnimplementedRuntimeException;
import alluxio.exception.runtime.UnknownRuntimeException;
import alluxio.grpc.ErrorType;
import alluxio.util.io.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);

    public static void changeLocalFileGroup(String path, String group) throws IOException {
        UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
        PosixFileAttributeView view = Files.getFileAttributeView(Paths.get(path, new String[0]), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        GroupPrincipal groupPrincipal = lookupService.lookupPrincipalByGroupName(group);
        view.setGroup(groupPrincipal);
    }

    public static void changeLocalFilePermission(String filePath, String perms) {
        try {
            Files.setPosixFilePermissions(Paths.get(filePath, new String[0]), PosixFilePermissions.fromString(perms));
        }
        catch (UnsupportedOperationException e) {
            throw new UnimplementedRuntimeException(e, ErrorType.External);
        }
        catch (ClassCastException e) {
            throw new InvalidArgumentRuntimeException(e);
        }
        catch (SecurityException e) {
            throw new PermissionDeniedRuntimeException(e);
        }
        catch (IOException e) {
            throw new UnknownRuntimeException(e);
        }
    }

    public static void changeLocalFileToFullPermission(String filePath) {
        FileUtils.changeLocalFilePermission(filePath, "rwxrwxrwx");
    }

    public static short getLocalFileMode(String filePath) throws IOException {
        Set<PosixFilePermission> permission = Files.readAttributes(Paths.get(filePath, new String[0]), PosixFileAttributes.class, new LinkOption[0]).permissions();
        return FileUtils.translatePosixPermissionToMode(permission);
    }

    public static short translatePosixPermissionToMode(Set<PosixFilePermission> permission) {
        int mode = 0;
        for (PosixFilePermission action : PosixFilePermission.values()) {
            mode <<= 1;
            mode += permission.contains((Object)action) ? 1 : 0;
        }
        return (short)mode;
    }

    public static Set<PosixFilePermission> translateModeToPosixPermissions(int mode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        Preconditions.checkArgument((mode >= 0 ? 1 : 0) != 0, (Object)"Mode can not be a negative value");
        if ((mode & 0x100) != 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    public static void changeLocalFileUser(String path, String user) throws IOException {
        UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
        PosixFileAttributeView view = Files.getFileAttributeView(Paths.get(path, new String[0]), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        UserPrincipal userPrincipal = lookupService.lookupPrincipalByName(user);
        view.setOwner(userPrincipal);
    }

    public static void setLocalDirStickyBit(String dir) {
        try {
            if (dir.startsWith("/")) {
                Runtime.getRuntime().exec("chmod +t " + dir);
            }
        }
        catch (IOException e) {
            LOG.info("Can not set the sticky bit of the directory: {}", (Object)dir, (Object)e);
        }
    }

    @VisibleForTesting
    public static void createBlockPath(String path, String workerDataFolderPermissions) {
        try {
            String parent = PathUtils.getParent(path);
            FileUtils.createStorageDirPath(parent, workerDataFolderPermissions);
        }
        catch (InvalidPathException e) {
            throw new InternalRuntimeException("Failed to create block path, get parent path of " + path + "failed", e);
        }
    }

    public static void move(String srcPath, String dstPath) throws IOException {
        Files.move(Paths.get(srcPath, new String[0]), Paths.get(dstPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void delete(String path) {
        try {
            Files.delete(Paths.get(path, new String[0]));
        }
        catch (java.nio.file.InvalidPathException e) {
            throw new InvalidArgumentRuntimeException(e);
        }
        catch (NoSuchFileException e) {
            throw new NotFoundRuntimeException(e);
        }
        catch (DirectoryNotEmptyException e) {
            throw new FailedPreconditionRuntimeException(e);
        }
        catch (SecurityException e) {
            throw new PermissionDeniedRuntimeException(e);
        }
        catch (IOException e) {
            throw new UnknownRuntimeException(e);
        }
    }

    public static void deleteIfExists(String path) {
        try {
            Files.deleteIfExists(Paths.get(path, new String[0]));
        }
        catch (java.nio.file.InvalidPathException e) {
            throw new InvalidArgumentRuntimeException(e);
        }
        catch (DirectoryNotEmptyException e) {
            throw new FailedPreconditionRuntimeException(e);
        }
        catch (SecurityException e) {
            throw new PermissionDeniedRuntimeException(e);
        }
        catch (IOException e) {
            throw new UnknownRuntimeException(e);
        }
    }

    public static void deletePathRecursively(String path) throws IOException {
        if (!FileUtils.exists(path)) {
            return;
        }
        Path root = Paths.get(path, new String[0]);
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw e;
            }
        });
    }

    public static boolean createStorageDirPath(String path, String workerDataFolderPermissions) {
        Path storagePath;
        if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            return false;
        }
        try {
            storagePath = Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        }
        catch (UnsupportedOperationException e) {
            throw new UnimplementedRuntimeException(e, ErrorType.External);
        }
        catch (FileAlreadyExistsException e) {
            throw new AlreadyExistsRuntimeException(e);
        }
        catch (SecurityException e) {
            throw new PermissionDeniedRuntimeException(e);
        }
        catch (IOException e) {
            throw new UnknownRuntimeException(e);
        }
        String absolutePath = storagePath.toAbsolutePath().toString();
        FileUtils.changeLocalFilePermission(absolutePath, workerDataFolderPermissions);
        FileUtils.setLocalDirStickyBit(absolutePath);
        return true;
    }

    public static void createFile(String filePath) {
        Path storagePath = Paths.get(filePath, new String[0]);
        Path parent = storagePath.getParent();
        try {
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.createFile(storagePath, new FileAttribute[0]);
        }
        catch (UnsupportedOperationException e) {
            throw new UnimplementedRuntimeException(e, ErrorType.External);
        }
        catch (ClassCastException e) {
            throw new InvalidArgumentRuntimeException(e);
        }
        catch (SecurityException e) {
            throw new PermissionDeniedRuntimeException(e);
        }
        catch (IOException e) {
            throw new UnknownRuntimeException(e);
        }
    }

    public static void createDir(String path) throws IOException {
        Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
    }

    public static boolean exists(String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public static boolean isStorageDirAccessible(String path) {
        Path filePath = Paths.get(path, new String[0]);
        return Files.exists(filePath, new LinkOption[0]) && Files.isReadable(filePath) && Files.isWritable(filePath) && Files.isExecutable(filePath);
    }

    private FileUtils() {
    }
}

