/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.data;

import com.google.common.base.Preconditions;
import io.codearte.jfairy.data.DataMaster;
import io.codearte.jfairy.producer.BaseProducer;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.yaml.snakeyaml.Yaml;

public class MapBasedDataMaster
implements DataMaster {
    private final BaseProducer baseProducer;
    private Map<String, Object> dataSource = new CaseInsensitiveMap();

    @Inject
    public MapBasedDataMaster(BaseProducer baseProducer) {
        this.baseProducer = baseProducer;
    }

    @Override
    public List<String> getStringList(String key) {
        return this.getData(key, List.class);
    }

    public Map<String, Integer> getIntegerValueMap(String key) {
        return this.getData(key, Map.class);
    }

    public Map<String, List<String>> getStringMap(String key) {
        return this.getData(key, Map.class);
    }

    @Override
    public String getValuesOfType(String dataKey, String type) {
        Map<String, List<String>> stringMap = this.getStringMap(dataKey);
        List<String> entries = stringMap.get(type);
        return this.baseProducer.randomElement(entries);
    }

    @Override
    public String getString(String key) {
        return this.getData(key, String.class);
    }

    @Override
    public String getRandomValue(String key) {
        return this.baseProducer.randomElement(this.getStringList(key));
    }

    private <T> T getData(String key, Class<T> type) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        Object element = this.dataSource.get(key);
        Preconditions.checkArgument((element != null ? 1 : 0) != 0, (String)"No such key: %s", (Object)key);
        Preconditions.checkArgument((boolean)type.isAssignableFrom(element.getClass()), (String)"Element under desired key has incorrect type - should be %s", (Object)type.getSimpleName());
        return (T)element;
    }

    public void readResources(String path) throws IOException {
        Enumeration<URL> resources = this.getClass().getClassLoader().getResources(path);
        if (!resources.hasMoreElements()) {
            throw new IllegalArgumentException(String.format("File %s was not found on classpath", path));
        }
        Yaml yaml = new Yaml();
        while (resources.hasMoreElements()) {
            this.appendData((Data)yaml.loadAs(resources.nextElement().openStream(), Data.class));
        }
    }

    private void appendData(Data dataMaster) {
        this.dataSource.putAll(dataMaster.getData());
    }

    private static class CaseInsensitiveMap
    extends HashMap<String, Object> {
        private CaseInsensitiveMap() {
        }

        @Override
        public Object put(String key, Object value) {
            String loweredKey = key.toLowerCase();
            Object valueToInsert = value;
            if (value instanceof Map) {
                valueToInsert = new CaseInsensitiveMap();
                ((CaseInsensitiveMap)valueToInsert).putAll((Map)value);
            }
            return super.put(loweredKey, valueToInsert);
        }

        @Override
        public void putAll(Map<? extends String, ?> map) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object get(Object key) {
            return super.get(((String)key).toLowerCase());
        }
    }

    public static class Data {
        private Map<String, Object> data;

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        private Map<String, Object> getData() {
            return this.data;
        }
    }
}

