/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer.person.locale.ka;

import io.codearte.jfairy.producer.BaseProducer;
import io.codearte.jfairy.producer.person.NationalIdentityCardNumberProvider;
import java.util.function.Supplier;
import javax.inject.Inject;

public class KaNationalIdentityCardNumberProvider
implements NationalIdentityCardNumberProvider {
    private final Supplier<NationalIdentityCardNumberProvider> formatPicker;

    @Inject
    public KaNationalIdentityCardNumberProvider(BaseProducer baseProducer) {
        OldCardNumberProvider oldCardNumberProvider = new OldCardNumberProvider(baseProducer);
        NewCardNumberProvider newCardNumberProvider = new NewCardNumberProvider(baseProducer);
        this.formatPicker = () -> baseProducer.randomElement(oldCardNumberProvider, newCardNumberProvider);
    }

    @Override
    public String get() {
        NationalIdentityCardNumberProvider numberProvider = this.formatPicker.get();
        return numberProvider.get();
    }

    private static class NewCardNumberProvider
    implements NationalIdentityCardNumberProvider {
        private static final String NEW_CARD_MASK = "##??#####";
        private final BaseProducer baseProducer;

        public NewCardNumberProvider(BaseProducer baseProducer) {
            this.baseProducer = baseProducer;
        }

        @Override
        public String get() {
            return this.baseProducer.bothify(NEW_CARD_MASK).toUpperCase();
        }
    }

    private static class OldCardNumberProvider
    implements NationalIdentityCardNumberProvider {
        private static char[] GEORGIAN_CHAR = "\u10d0\u10d1\u10d2\u10d3\u10d4\u10d5\u10d6\u10d7\u10d8\u10d9\u10da\u10db\u10dc\u10dd\u10de\u10df\u10e0\u10e1\u10e2\u10e3\u10e4\u10e5\u10e6\u10e7\u10e8\u10e9\u10ea\u10eb\u10ec\u10ed\u10ee\u10ef\u10f0".toCharArray();
        private final BaseProducer baseProducer;

        public OldCardNumberProvider(BaseProducer baseProducer) {
            this.baseProducer = baseProducer;
        }

        @Override
        public String get() {
            char geChar = GEORGIAN_CHAR[this.baseProducer.randomInt(GEORGIAN_CHAR.length - 1)];
            return "N" + geChar + this.baseProducer.numerify("#######");
        }
    }
}

