/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.bytes;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.opensearch.common.Nullable;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.bytes.CompositeBytesReference;
import org.opensearch.common.io.stream.BytesStream;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.ByteArray;
import org.opensearch.core.internal.io.IOUtils;

public class RecyclingBytesStreamOutput
extends BytesStream {
    private final byte[] buffer;
    private final BigArrays bigArrays;
    private int position;
    @Nullable
    private ByteArray overflow;

    public RecyclingBytesStreamOutput(byte[] buffer, BigArrays bigArrays) {
        this.buffer = Objects.requireNonNull(buffer);
        this.bigArrays = Objects.requireNonNull(bigArrays);
    }

    @Override
    public void writeByte(byte b) {
        if (this.position < this.buffer.length) {
            this.buffer[this.position++] = b;
        } else {
            this.ensureCapacity(this.position + 1);
            this.overflow.set(this.position++ - this.buffer.length, b);
        }
    }

    private void ensureCapacity(int size) {
        int overflowSize = size - this.buffer.length;
        assert (overflowSize > 0) : "no need to ensureCapacity(" + size + ") with buffer of size [" + this.buffer.length + "]";
        assert (this.position >= this.buffer.length) : "no need to ensureCapacity(" + size + ") with buffer of size [" + this.buffer.length + "] at position [" + this.position + "]";
        if (this.overflow == null) {
            this.overflow = this.bigArrays.newByteArray(overflowSize, false);
        } else if ((long)overflowSize > this.overflow.size()) {
            this.overflow = this.bigArrays.resize(this.overflow, (long)overflowSize);
        }
        assert (this.overflow.size() >= (long)overflowSize);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) {
        if (this.position < this.buffer.length) {
            int lengthForBuffer = Math.min(length, this.buffer.length - this.position);
            System.arraycopy(b, offset, this.buffer, this.position, lengthForBuffer);
            this.position += lengthForBuffer;
            offset += lengthForBuffer;
            length -= lengthForBuffer;
        }
        if (length > 0) {
            this.ensureCapacity(this.position + length);
            this.overflow.set(this.position - this.buffer.length, b, offset, length);
            this.position += length;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.overflow);
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public BytesRef toBytesRef() {
        if (this.position <= this.buffer.length) {
            assert (this.overflow == null);
            return new BytesRef(this.buffer, 0, this.position);
        }
        byte[] newBuffer = new byte[this.position];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
        int copyPos = this.buffer.length;
        BytesRefIterator iterator = BytesReference.fromByteArray(this.overflow, this.position - this.buffer.length).iterator();
        try {
            BytesRef bytesRef;
            while ((bytesRef = iterator.next()) != null) {
                assert (copyPos + bytesRef.length <= this.position);
                System.arraycopy(bytesRef.bytes, bytesRef.offset, newBuffer, copyPos, bytesRef.length);
                copyPos += bytesRef.length;
            }
        }
        catch (IOException e) {
            throw new AssertionError("impossible", e);
        }
        return new BytesRef(newBuffer, 0, this.position);
    }

    @Override
    public BytesReference bytes() {
        if (this.position <= this.buffer.length) {
            assert (this.overflow == null);
            return new BytesArray(this.buffer, 0, this.position);
        }
        return CompositeBytesReference.of(new BytesArray(this.buffer, 0, this.buffer.length), BytesReference.fromByteArray(this.overflow, this.position - this.buffer.length));
    }
}

