/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery.zen;

import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.OpenSearchException;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.NotMasterException;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.MasterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchRejectedExecutionException;
import org.opensearch.discovery.zen.FaultDetection;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponse;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class MasterFaultDetection
extends FaultDetection {
    private static final Logger logger = LogManager.getLogger(MasterFaultDetection.class);
    public static final String MASTER_PING_ACTION_NAME = "internal:discovery/zen/fd/master_ping";
    private final MasterService masterService;
    private final Supplier<ClusterState> clusterStateSupplier;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();
    private volatile MasterPinger masterPinger;
    private final Object masterNodeMutex = new Object();
    private volatile DiscoveryNode masterNode;
    private volatile int retryCount;
    private final AtomicBoolean notifiedMasterFailure = new AtomicBoolean();

    public MasterFaultDetection(Settings settings, ThreadPool threadPool, TransportService transportService, Supplier<ClusterState> clusterStateSupplier, MasterService masterService, ClusterName clusterName) {
        super(settings, threadPool, transportService, clusterName);
        this.clusterStateSupplier = clusterStateSupplier;
        this.masterService = masterService;
        logger.debug("[master] uses ping_interval [{}], ping_timeout [{}], ping_retries [{}]", (Object)this.pingInterval, (Object)this.pingRetryTimeout, (Object)this.pingRetryCount);
        transportService.registerRequestHandler(MASTER_PING_ACTION_NAME, "same", false, false, MasterPingRequest::new, new MasterPingRequestHandler());
    }

    public DiscoveryNode masterNode() {
        return this.masterNode;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(DiscoveryNode masterNode, String reason) {
        Object object = this.masterNodeMutex;
        synchronized (object) {
            if (logger.isDebugEnabled()) {
                logger.debug("[master] restarting fault detection against master [{}], reason [{}]", (Object)masterNode, (Object)reason);
            }
            this.innerStop();
            this.innerStart(masterNode);
        }
    }

    private void innerStart(DiscoveryNode masterNode) {
        this.masterNode = masterNode;
        this.retryCount = 0;
        this.notifiedMasterFailure.set(false);
        if (this.masterPinger != null) {
            this.masterPinger.stop();
        }
        this.masterPinger = new MasterPinger();
        this.threadPool.schedule(this.masterPinger, this.pingInterval, "same");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String reason) {
        Object object = this.masterNodeMutex;
        synchronized (object) {
            if (this.masterNode != null && logger.isDebugEnabled()) {
                logger.debug("[master] stopping fault detection against master [{}], reason [{}]", (Object)this.masterNode, (Object)reason);
            }
            this.innerStop();
        }
    }

    private void innerStop() {
        this.retryCount = 0;
        if (this.masterPinger != null) {
            this.masterPinger.stop();
            this.masterPinger = null;
        }
        this.masterNode = null;
    }

    @Override
    public void close() {
        super.close();
        this.stop("closing");
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleTransportDisconnect(DiscoveryNode node) {
        Object object = this.masterNodeMutex;
        synchronized (object) {
            if (!node.equals(this.masterNode)) {
                return;
            }
            if (this.connectOnNetworkDisconnect) {
                try {
                    this.transportService.connectToNode(node);
                    if (this.masterPinger != null) {
                        this.masterPinger.stop();
                    }
                    this.masterPinger = new MasterPinger();
                    this.threadPool.schedule(this.masterPinger, TimeValue.timeValueMillis((long)0L), "same");
                }
                catch (Exception e) {
                    logger.trace("[master] [{}] transport disconnected (with verified connect)", (Object)this.masterNode);
                    this.notifyMasterFailure(this.masterNode, null, "transport disconnected (with verified connect)");
                }
            } else {
                logger.trace("[master] [{}] transport disconnected", (Object)node);
                this.notifyMasterFailure(node, null, "transport disconnected");
            }
        }
    }

    private void notifyMasterFailure(DiscoveryNode masterNode, Throwable cause, String reason) {
        if (this.notifiedMasterFailure.compareAndSet(false, true)) {
            try {
                this.threadPool.generic().execute(() -> {
                    for (Listener listener : this.listeners) {
                        listener.onMasterFailure(masterNode, cause, reason);
                    }
                });
            }
            catch (OpenSearchRejectedExecutionException e) {
                logger.error("master failure notification was rejected, it's highly likely the node is shutting down", (Throwable)e);
            }
            this.stop("master failure, " + reason);
        }
    }

    private class MasterPingRequestHandler
    implements TransportRequestHandler<MasterPingRequest> {
        private MasterPingRequestHandler() {
        }

        @Override
        public void messageReceived(final MasterPingRequest request, final TransportChannel channel, Task task) throws Exception {
            DiscoveryNodes nodes = ((ClusterState)MasterFaultDetection.this.clusterStateSupplier.get()).nodes();
            if (!request.masterNode.equals(nodes.getLocalNode())) {
                throw new ThisIsNotTheMasterYouAreLookingForException();
            }
            if (request.clusterName != null && !request.clusterName.equals(MasterFaultDetection.this.clusterName)) {
                logger.trace("master fault detection ping request is targeted for a different [{}] cluster then us [{}]", (Object)request.clusterName, (Object)MasterFaultDetection.this.clusterName);
                throw new ThisIsNotTheMasterYouAreLookingForException("master fault detection ping request is targeted for a different [" + request.clusterName + "] cluster then us [" + MasterFaultDetection.this.clusterName + "]");
            }
            if (!nodes.isLocalNodeElectedMaster() || !nodes.nodeExists(request.sourceNode)) {
                logger.trace("checking ping from {} under a cluster state thread", (Object)request.sourceNode);
                MasterFaultDetection.this.masterService.submitStateUpdateTask("master ping (from: " + request.sourceNode + ")", new ClusterStateUpdateTask(){

                    @Override
                    public ClusterState execute(ClusterState currentState) throws Exception {
                        DiscoveryNodes nodes = currentState.nodes();
                        if (!nodes.nodeExists(request.sourceNode)) {
                            throw new NodeDoesNotExistOnMasterException();
                        }
                        return currentState;
                    }

                    @Override
                    public void onNoLongerMaster(String source) {
                        this.onFailure(source, new NotMasterException("local node is not master"));
                    }

                    @Override
                    public void onFailure(String source, @Nullable Exception e) {
                        if (e == null) {
                            e = new OpenSearchException("unknown error while processing ping", new Object[0]);
                        }
                        try {
                            channel.sendResponse(e);
                        }
                        catch (IOException inner) {
                            inner.addSuppressed(e);
                            logger.warn("error while sending ping response", (Throwable)inner);
                        }
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        try {
                            channel.sendResponse(new MasterPingResponseResponse());
                        }
                        catch (IOException e) {
                            logger.warn("error while sending ping response", (Throwable)e);
                        }
                    }
                });
            } else {
                channel.sendResponse(new MasterPingResponseResponse());
            }
        }
    }

    private class MasterPinger
    implements Runnable {
        private volatile boolean running = true;

        private MasterPinger() {
        }

        public void stop() {
            this.running = false;
        }

        @Override
        public void run() {
            if (!this.running) {
                return;
            }
            final DiscoveryNode masterToPing = MasterFaultDetection.this.masterNode;
            if (masterToPing == null) {
                MasterFaultDetection.this.threadPool.schedule(this, MasterFaultDetection.this.pingInterval, "same");
                return;
            }
            final MasterPingRequest request = new MasterPingRequest(((ClusterState)MasterFaultDetection.this.clusterStateSupplier.get()).nodes().getLocalNode(), masterToPing, MasterFaultDetection.this.clusterName);
            final TransportRequestOptions options = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.PING).withTimeout(MasterFaultDetection.this.pingRetryTimeout).build();
            MasterFaultDetection.this.transportService.sendRequest(masterToPing, MasterFaultDetection.MASTER_PING_ACTION_NAME, (TransportRequest)request, options, new TransportResponseHandler<MasterPingResponseResponse>(){

                @Override
                public MasterPingResponseResponse read(StreamInput in) throws IOException {
                    return new MasterPingResponseResponse(in);
                }

                @Override
                public void handleResponse(MasterPingResponseResponse response) {
                    if (!MasterPinger.this.running) {
                        return;
                    }
                    MasterFaultDetection.this.retryCount = 0;
                    if (masterToPing.equals(MasterFaultDetection.this.masterNode())) {
                        MasterFaultDetection.this.threadPool.schedule(MasterPinger.this, MasterFaultDetection.this.pingInterval, "same");
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleException(TransportException exp) {
                    if (!MasterPinger.this.running) {
                        return;
                    }
                    Object object = MasterFaultDetection.this.masterNodeMutex;
                    synchronized (object) {
                        if (masterToPing.equals(MasterFaultDetection.this.masterNode())) {
                            if (exp instanceof ConnectTransportException || exp.getCause() instanceof ConnectTransportException) {
                                MasterFaultDetection.this.handleTransportDisconnect(masterToPing);
                                return;
                            }
                            if (exp.getCause() instanceof NotMasterException) {
                                logger.debug("[master] pinging a master {} that is no longer a master", (Object)MasterFaultDetection.this.masterNode);
                                MasterFaultDetection.this.notifyMasterFailure(masterToPing, exp, "no longer master");
                                return;
                            }
                            if (exp.getCause() instanceof ThisIsNotTheMasterYouAreLookingForException) {
                                logger.debug("[master] pinging a master {} that is not the master", (Object)MasterFaultDetection.this.masterNode);
                                MasterFaultDetection.this.notifyMasterFailure(masterToPing, exp, "not master");
                                return;
                            }
                            if (exp.getCause() instanceof NodeDoesNotExistOnMasterException) {
                                logger.debug("[master] pinging a master {} but we do not exists on it, act as if its master failure", (Object)MasterFaultDetection.this.masterNode);
                                MasterFaultDetection.this.notifyMasterFailure(masterToPing, exp, "do not exists on master, act as master failure");
                                return;
                            }
                            int retryCount = ++MasterFaultDetection.this.retryCount;
                            logger.trace(() -> new ParameterizedMessage("[master] failed to ping [{}], retry [{}] out of [{}]", new Object[]{MasterFaultDetection.this.masterNode, retryCount, MasterFaultDetection.this.pingRetryCount}), (Throwable)exp);
                            if (retryCount >= MasterFaultDetection.this.pingRetryCount) {
                                logger.debug("[master] failed to ping [{}], tried [{}] times, each with maximum [{}] timeout", (Object)MasterFaultDetection.this.masterNode, (Object)MasterFaultDetection.this.pingRetryCount, (Object)MasterFaultDetection.this.pingRetryTimeout);
                                MasterFaultDetection.this.notifyMasterFailure(masterToPing, null, "failed to ping, tried [" + MasterFaultDetection.this.pingRetryCount + "] times, each with  maximum [" + MasterFaultDetection.this.pingRetryTimeout + "] timeout");
                            } else {
                                MasterFaultDetection.this.transportService.sendRequest(masterToPing, MasterFaultDetection.MASTER_PING_ACTION_NAME, (TransportRequest)request, options, this);
                            }
                        }
                    }
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public static interface Listener {
        public void onMasterFailure(DiscoveryNode var1, Throwable var2, String var3);
    }

    public static class MasterPingResponseResponse
    extends TransportResponse {
        public MasterPingResponseResponse() {
        }

        public MasterPingResponseResponse(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }
    }

    public static class MasterPingRequest
    extends TransportRequest {
        public DiscoveryNode sourceNode;
        private DiscoveryNode masterNode;
        private ClusterName clusterName;

        public MasterPingRequest(StreamInput in) throws IOException {
            super(in);
            this.sourceNode = new DiscoveryNode(in);
            this.masterNode = new DiscoveryNode(in);
            this.clusterName = new ClusterName(in);
        }

        public MasterPingRequest(DiscoveryNode sourceNode, DiscoveryNode masterNode, ClusterName clusterName) {
            this.sourceNode = sourceNode;
            this.masterNode = masterNode;
            this.clusterName = clusterName;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.sourceNode.writeTo(out);
            this.masterNode.writeTo(out);
            this.clusterName.writeTo(out);
        }
    }

    static class NodeDoesNotExistOnMasterException
    extends IllegalStateException {
        NodeDoesNotExistOnMasterException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }

    public static class ThisIsNotTheMasterYouAreLookingForException
    extends IllegalStateException {
        public ThisIsNotTheMasterYouAreLookingForException(String msg) {
            super(msg);
        }

        public ThisIsNotTheMasterYouAreLookingForException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }
}

