/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query.functionscore;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.io.stream.NamedWriteable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.lucene.search.function.ScoreFunction;
import org.opensearch.common.lucene.search.function.WeightFactorFunction;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;

public abstract class ScoreFunctionBuilder<FB extends ScoreFunctionBuilder<FB>>
implements ToXContentFragment,
NamedWriteable {
    private Float weight;

    public ScoreFunctionBuilder() {
    }

    public ScoreFunctionBuilder(StreamInput in) throws IOException {
        this.weight = this.checkWeight(in.readOptionalFloat());
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalFloat(this.weight);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public abstract String getName();

    public final FB setWeight(float weight) {
        this.weight = this.checkWeight(Float.valueOf(weight));
        return (FB)this;
    }

    private Float checkWeight(Float weight) {
        if (weight != null && Float.compare(weight.floatValue(), 0.0f) < 0) {
            throw new IllegalArgumentException("[weight] cannot be negative for a filtering function");
        }
        return weight;
    }

    public final Float getWeight() {
        return this.weight;
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.weight != null) {
            builder.field(FunctionScoreQueryBuilder.WEIGHT_FIELD.getPreferredName(), this.weight);
        }
        this.doXContent(builder, params);
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public String getWriteableName() {
        return this.getName();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScoreFunctionBuilder other = (ScoreFunctionBuilder)obj;
        return Objects.equals(this.weight, other.getWeight()) && this.doEquals(other);
    }

    protected abstract boolean doEquals(FB var1);

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.weight, this.doHashCode());
    }

    protected abstract int doHashCode();

    public final ScoreFunction toFunction(QueryShardContext context) throws IOException {
        ScoreFunction scoreFunction = this.doToFunction(context);
        if (this.weight == null) {
            return scoreFunction;
        }
        return new WeightFactorFunction(this.weight.floatValue(), scoreFunction);
    }

    protected abstract ScoreFunction doToFunction(QueryShardContext var1) throws IOException;
}

