/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorable;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.lucene.ScorerAware;
import org.opensearch.common.util.BigArray;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.BitArray;
import org.opensearch.common.util.DoubleArray;
import org.opensearch.common.util.FloatArray;
import org.opensearch.common.util.LongArray;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.search.sort.SortValue;

public abstract class BucketedSort
implements Releasable {
    public static final ExtraData NOOP_EXTRA_DATA = new ExtraData(){

        @Override
        public void swap(long lhs, long rhs) {
        }

        @Override
        public ExtraData.Loader loader(LeafReaderContext ctx) throws IOException {
            return (index, doc) -> {};
        }
    };
    protected final BigArrays bigArrays;
    private final SortOrder order;
    private final DocValueFormat format;
    private final int bucketSize;
    private final ExtraData extra;
    private final BitArray heapMode;

    protected BucketedSort(BigArrays bigArrays, SortOrder order, DocValueFormat format, int bucketSize, ExtraData extra) {
        this.bigArrays = bigArrays;
        this.order = order;
        this.format = format;
        this.bucketSize = bucketSize;
        this.extra = extra;
        this.heapMode = new BitArray(1L, bigArrays);
    }

    public final SortOrder getOrder() {
        return this.order;
    }

    public final DocValueFormat getFormat() {
        return this.format;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public final <T extends Comparable<T>> List<T> getValues(long bucket, ResultBuilder<T> builder) {
        long rootIndex = bucket * (long)this.bucketSize;
        if (rootIndex >= this.values().size()) {
            return Collections.emptyList();
        }
        long start = this.inHeapMode(bucket) ? rootIndex : rootIndex + (long)this.getNextGatherOffset(rootIndex) + 1L;
        long end = rootIndex + (long)this.bucketSize;
        ArrayList result = new ArrayList(this.bucketSize);
        for (long index = start; index < end; ++index) {
            result.add((Comparable)builder.build(index, this.getValue(index)));
        }
        result.sort(this.order.wrap(Comparator.naturalOrder()));
        return result;
    }

    public final List<SortValue> getValues(long bucket) {
        return this.getValues(bucket, (i, sv) -> sv);
    }

    private boolean inHeapMode(long bucket) {
        return this.heapMode.get(bucket);
    }

    public abstract Leaf forLeaf(LeafReaderContext var1) throws IOException;

    public abstract boolean needsScores();

    protected abstract BigArray values();

    protected abstract void growValues(long var1);

    protected abstract int getNextGatherOffset(long var1);

    protected abstract void setNextGatherOffset(long var1, int var3);

    protected abstract SortValue getValue(long var1);

    protected abstract boolean betterThan(long var1, long var3);

    protected abstract void swap(long var1, long var3);

    protected final String debugFormat() {
        StringBuilder b = new StringBuilder();
        for (long index = 0L; index < this.values().size(); ++index) {
            if (index % (long)this.bucketSize == 0L) {
                b.append('\n').append(String.format(Locale.ROOT, "%20d", index / (long)this.bucketSize)).append(":  ");
            }
            b.append(String.format(Locale.ROOT, "%20s", this.getValue(index))).append(' ');
        }
        return b.toString();
    }

    protected final void initGatherOffsets() {
        this.setNextGatherOffsets(0L);
    }

    private void grow(long minSize) {
        long oldMax = this.values().size() - 1L;
        this.growValues(minSize);
        this.setNextGatherOffsets(oldMax - oldMax % (long)this.getBucketSize() + (long)this.getBucketSize());
    }

    private void setNextGatherOffsets(long startingAt) {
        int nextOffset = this.getBucketSize() - 1;
        for (long bucketRoot = startingAt; bucketRoot < this.values().size(); bucketRoot += (long)this.getBucketSize()) {
            this.setNextGatherOffset(bucketRoot, nextOffset);
        }
    }

    private void heapify(long rootIndex) {
        int maxParent;
        for (int parent = maxParent = this.bucketSize / 2 - 1; parent >= 0; --parent) {
            this.downHeap(rootIndex, parent);
        }
    }

    private void downHeap(long rootIndex, int parent) {
        while (true) {
            long parentIndex = rootIndex + (long)parent;
            int worst = parent;
            long worstIndex = parentIndex;
            int leftChild = parent * 2 + 1;
            long leftIndex = rootIndex + (long)leftChild;
            if (leftChild < this.bucketSize) {
                if (this.betterThan(worstIndex, leftIndex)) {
                    worst = leftChild;
                    worstIndex = leftIndex;
                }
                int rightChild = leftChild + 1;
                long rightIndex = rootIndex + (long)rightChild;
                if (rightChild < this.bucketSize && this.betterThan(worstIndex, rightIndex)) {
                    worst = rightChild;
                    worstIndex = rightIndex;
                }
            }
            if (worst == parent) break;
            this.swap(worstIndex, parentIndex);
            this.extra.swap(worstIndex, parentIndex);
            parent = worst;
        }
    }

    @Override
    public final void close() {
        Releasables.close(this.values(), this.heapMode);
    }

    public static interface ExtraData {
        public void swap(long var1, long var3);

        public Loader loader(LeafReaderContext var1) throws IOException;

        @FunctionalInterface
        public static interface Loader {
            public void loadFromDoc(long var1, int var3) throws IOException;
        }
    }

    @FunctionalInterface
    public static interface ResultBuilder<T> {
        public T build(long var1, SortValue var3);
    }

    public static abstract class ForLongs
    extends BucketedSort {
        private LongArray values;

        public ForLongs(BigArrays bigArrays, SortOrder sortOrder, DocValueFormat format, int bucketSize, ExtraData extra) {
            super(bigArrays, sortOrder, format, bucketSize, extra);
            this.values = this.bigArrays.newLongArray(1L, false);
            this.initGatherOffsets();
        }

        @Override
        public final boolean needsScores() {
            return false;
        }

        @Override
        protected final BigArray values() {
            return this.values;
        }

        @Override
        protected final void growValues(long minSize) {
            this.values = this.bigArrays.grow(this.values, minSize);
        }

        @Override
        protected final int getNextGatherOffset(long rootIndex) {
            return (int)this.values.get(rootIndex);
        }

        @Override
        protected final void setNextGatherOffset(long rootIndex, int offset) {
            this.values.set(rootIndex, offset);
        }

        @Override
        protected final SortValue getValue(long index) {
            return SortValue.from(this.values.get(index));
        }

        @Override
        protected final boolean betterThan(long lhs, long rhs) {
            return this.getOrder().reverseMul() * Long.compare(this.values.get(lhs), this.values.get(rhs)) < 0;
        }

        @Override
        protected final void swap(long lhs, long rhs) {
            long tmp = this.values.get(lhs);
            this.values.set(lhs, this.values.get(rhs));
            this.values.set(rhs, tmp);
        }

        protected abstract class Leaf
        extends org.opensearch.search.sort.BucketedSort$Leaf {
            protected Leaf(LeafReaderContext ctx) {
                super(ctx);
            }

            protected abstract long docValue();

            @Override
            public final void setScorer(Scorable scorer) {
            }

            @Override
            protected final void setIndexToDocValue(long index) {
                ForLongs.this.values.set(index, this.docValue());
            }

            @Override
            protected final boolean docBetterThan(long index) {
                return ForLongs.this.getOrder().reverseMul() * Long.compare(this.docValue(), ForLongs.this.values.get(index)) < 0;
            }
        }
    }

    public static abstract class ForFloats
    extends BucketedSort {
        public static final int MAX_BUCKET_SIZE = (int)Math.pow(2.0, 24.0);
        private FloatArray values;

        public ForFloats(BigArrays bigArrays, SortOrder sortOrder, DocValueFormat format, int bucketSize, ExtraData extra) {
            super(bigArrays, sortOrder, format, bucketSize, extra);
            this.values = this.bigArrays.newFloatArray(1L, false);
            if (bucketSize > MAX_BUCKET_SIZE) {
                this.close();
                throw new IllegalArgumentException("bucket size must be less than [2^24] but was [" + bucketSize + "]");
            }
            this.initGatherOffsets();
        }

        @Override
        protected final BigArray values() {
            return this.values;
        }

        @Override
        protected final void growValues(long minSize) {
            this.values = this.bigArrays.grow(this.values, minSize);
        }

        @Override
        protected final int getNextGatherOffset(long rootIndex) {
            return (int)this.values.get(rootIndex);
        }

        @Override
        protected final void setNextGatherOffset(long rootIndex, int offset) {
            this.values.set(rootIndex, offset);
        }

        @Override
        protected final SortValue getValue(long index) {
            return SortValue.from(this.values.get(index));
        }

        @Override
        protected final boolean betterThan(long lhs, long rhs) {
            return this.getOrder().reverseMul() * Float.compare(this.values.get(lhs), this.values.get(rhs)) < 0;
        }

        @Override
        protected final void swap(long lhs, long rhs) {
            float tmp = this.values.get(lhs);
            this.values.set(lhs, this.values.get(rhs));
            this.values.set(rhs, tmp);
        }

        protected abstract class Leaf
        extends org.opensearch.search.sort.BucketedSort$Leaf {
            protected Leaf(LeafReaderContext ctx) {
                super(ctx);
            }

            protected abstract float docValue();

            @Override
            protected final void setIndexToDocValue(long index) {
                ForFloats.this.values.set(index, this.docValue());
            }

            @Override
            protected final boolean docBetterThan(long index) {
                return ForFloats.this.getOrder().reverseMul() * Float.compare(this.docValue(), ForFloats.this.values.get(index)) < 0;
            }
        }
    }

    public static abstract class ForDoubles
    extends BucketedSort {
        private DoubleArray values;

        public ForDoubles(BigArrays bigArrays, SortOrder sortOrder, DocValueFormat format, int bucketSize, ExtraData extra) {
            super(bigArrays, sortOrder, format, bucketSize, extra);
            this.values = this.bigArrays.newDoubleArray(this.getBucketSize(), false);
            this.initGatherOffsets();
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        protected final BigArray values() {
            return this.values;
        }

        @Override
        protected final void growValues(long minSize) {
            this.values = this.bigArrays.grow(this.values, minSize);
        }

        @Override
        protected final int getNextGatherOffset(long rootIndex) {
            return (int)this.values.get(rootIndex);
        }

        @Override
        protected final void setNextGatherOffset(long rootIndex, int offset) {
            this.values.set(rootIndex, offset);
        }

        @Override
        protected final SortValue getValue(long index) {
            return SortValue.from(this.values.get(index));
        }

        @Override
        protected final boolean betterThan(long lhs, long rhs) {
            return this.getOrder().reverseMul() * Double.compare(this.values.get(lhs), this.values.get(rhs)) < 0;
        }

        @Override
        protected final void swap(long lhs, long rhs) {
            double tmp = this.values.get(lhs);
            this.values.set(lhs, this.values.get(rhs));
            this.values.set(rhs, tmp);
        }

        protected abstract class Leaf
        extends org.opensearch.search.sort.BucketedSort$Leaf {
            protected Leaf(LeafReaderContext ctx) {
                super(ctx);
            }

            protected abstract double docValue();

            @Override
            public final void setScorer(Scorable scorer) {
            }

            @Override
            protected final void setIndexToDocValue(long index) {
                ForDoubles.this.values.set(index, this.docValue());
            }

            @Override
            protected final boolean docBetterThan(long index) {
                return ForDoubles.this.getOrder().reverseMul() * Double.compare(this.docValue(), ForDoubles.this.values.get(index)) < 0;
            }
        }
    }

    public abstract class Leaf
    implements ScorerAware {
        private final LeafReaderContext ctx;
        private ExtraData.Loader loader = null;

        protected Leaf(LeafReaderContext ctx) {
            this.ctx = ctx;
        }

        public final void collect(int doc, long bucket) throws IOException {
            if (!this.advanceExact(doc)) {
                return;
            }
            long rootIndex = bucket * (long)BucketedSort.this.bucketSize;
            if (BucketedSort.this.inHeapMode(bucket)) {
                if (this.docBetterThan(rootIndex)) {
                    this.setIndexToDocValue(rootIndex);
                    this.loader().loadFromDoc(rootIndex, doc);
                    BucketedSort.this.downHeap(rootIndex, 0);
                }
                return;
            }
            long requiredSize = rootIndex + (long)BucketedSort.this.bucketSize;
            if (BucketedSort.this.values().size() < requiredSize) {
                BucketedSort.this.grow(requiredSize);
            }
            int next = BucketedSort.this.getNextGatherOffset(rootIndex);
            assert (0 <= next && next < BucketedSort.this.bucketSize) : "Expected next to be in the range of valid buckets [0 <= " + next + " < " + BucketedSort.access$000(BucketedSort.this) + "]";
            long index = (long)next + rootIndex;
            this.setIndexToDocValue(index);
            this.loader().loadFromDoc(index, doc);
            if (next == 0) {
                BucketedSort.this.heapMode.set(bucket);
                BucketedSort.this.heapify(rootIndex);
            } else {
                BucketedSort.this.setNextGatherOffset(rootIndex, next - 1);
            }
        }

        protected abstract boolean advanceExact(int var1) throws IOException;

        protected abstract void setIndexToDocValue(long var1);

        protected abstract boolean docBetterThan(long var1);

        private ExtraData.Loader loader() throws IOException {
            if (this.loader == null) {
                this.loader = BucketedSort.this.extra.loader(this.ctx);
            }
            return this.loader;
        }
    }
}

