/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.channel.AbstractChannelSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexingChannelSelector
extends AbstractChannelSelector {
    public static final String CONFIG_MULTIPLEX_HEADER_NAME = "header";
    public static final String DEFAULT_MULTIPLEX_HEADER = "flume.selector.header";
    public static final String CONFIG_PREFIX_MAPPING = "mapping.";
    public static final String CONFIG_DEFAULT_CHANNEL = "default";
    public static final String CONFIG_PREFIX_OPTIONAL = "optional";
    private static final Logger LOG = LoggerFactory.getLogger(MultiplexingChannelSelector.class);
    private static final List<Channel> EMPTY_LIST = Collections.emptyList();
    private String headerName;
    private Map<String, List<Channel>> channelMapping;
    private Map<String, List<Channel>> optionalChannels;
    private List<Channel> defaultChannels;

    @Override
    public List<Channel> getRequiredChannels(Event event) {
        String headerValue = (String)event.getHeaders().get(this.headerName);
        if (headerValue == null || headerValue.trim().length() == 0) {
            return this.defaultChannels;
        }
        List<Channel> channels = this.channelMapping.get(headerValue);
        if (channels == null) {
            channels = this.defaultChannels;
        }
        return channels;
    }

    @Override
    public List<Channel> getOptionalChannels(Event event) {
        String hdr = (String)event.getHeaders().get(this.headerName);
        List<Channel> channels = this.optionalChannels.get(hdr);
        if (channels == null) {
            channels = EMPTY_LIST;
        }
        return channels;
    }

    @Override
    public void configure(Context context) {
        this.headerName = context.getString(CONFIG_MULTIPLEX_HEADER_NAME, DEFAULT_MULTIPLEX_HEADER);
        Map<String, Channel> channelNameMap = this.getChannelNameMap();
        this.defaultChannels = this.getChannelListFromNames(context.getString(CONFIG_DEFAULT_CHANNEL), channelNameMap);
        ImmutableMap mapConfig = context.getSubProperties(CONFIG_PREFIX_MAPPING);
        this.channelMapping = new HashMap<String, List<Channel>>();
        for (String headerValue : mapConfig.keySet()) {
            List<Channel> configuredChannels = this.getChannelListFromNames((String)mapConfig.get(headerValue), channelNameMap);
            if (configuredChannels.size() == 0) {
                throw new FlumeException("No channel configured for when header value is: " + headerValue);
            }
            if (this.channelMapping.put(headerValue, configuredChannels) == null) continue;
            throw new FlumeException("Selector channel configured twice");
        }
        ImmutableMap optionalChannelsMapping = context.getSubProperties("optional.");
        this.optionalChannels = new HashMap<String, List<Channel>>();
        for (String hdr : optionalChannelsMapping.keySet()) {
            List<Channel> reqdChannels;
            List<Channel> confChannels = this.getChannelListFromNames((String)optionalChannelsMapping.get(hdr), channelNameMap);
            if (confChannels.isEmpty()) {
                confChannels = EMPTY_LIST;
            }
            if ((reqdChannels = this.channelMapping.get(hdr)) == null || reqdChannels.isEmpty()) {
                reqdChannels = this.defaultChannels;
            }
            for (Channel c : reqdChannels) {
                if (!confChannels.contains(c)) continue;
                confChannels.remove(c);
            }
            if (this.optionalChannels.put(hdr, confChannels) == null) continue;
            throw new FlumeException("Selector channel configured twice");
        }
    }
}

