/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.flume.Context;
import org.apache.flume.FlumeException;
import org.apache.flume.source.AbstractSource;
import org.apache.flume.util.SSLUtil;

public abstract class SslContextAwareAbstractSource
extends AbstractSource {
    private static final String SSL_ENABLED_KEY = "ssl";
    private static final boolean SSL_ENABLED_DEFAULT_VALUE = false;
    private static final String KEYSTORE_KEY = "keystore";
    private static final String KEYSTORE_PASSWORD_KEY = "keystore-password";
    private static final String KEYSTORE_TYPE_KEY = "keystore-type";
    private static final String KEYSTORE_TYPE_DEFAULT_VALUE = "JKS";
    private static final String EXCLUDE_PROTOCOLS = "exclude-protocols";
    private static final String INCLUDE_PROTOCOLS = "include-protocols";
    private static final String EXCLUDE_CIPHER_SUITES = "exclude-cipher-suites";
    private static final String INCLUDE_CIPHER_SUITES = "include-cipher-suites";
    private String keystore;
    private String keystorePassword;
    private String keystoreType;
    private boolean sslEnabled = false;
    private final Set<String> excludeProtocols = new LinkedHashSet<String>(Arrays.asList("SSLv3"));
    private final Set<String> includeProtocols = new LinkedHashSet<String>();
    private final Set<String> excludeCipherSuites = new LinkedHashSet<String>();
    private final Set<String> includeCipherSuites = new LinkedHashSet<String>();

    public String getKeystore() {
        return this.keystore;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public Set<String> getExcludeProtocols() {
        return this.excludeProtocols;
    }

    public Set<String> getIncludeProtocols() {
        return this.includeProtocols;
    }

    public Set<String> getExcludeCipherSuites() {
        return this.excludeCipherSuites;
    }

    public Set<String> getIncludeCipherSuites() {
        return this.includeCipherSuites;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    protected void configureSsl(Context context) {
        this.sslEnabled = context.getBoolean(SSL_ENABLED_KEY, Boolean.valueOf(false));
        this.keystore = context.getString(KEYSTORE_KEY, SSLUtil.getGlobalKeystorePath());
        this.keystorePassword = context.getString(KEYSTORE_PASSWORD_KEY, SSLUtil.getGlobalKeystorePassword());
        this.keystoreType = context.getString(KEYSTORE_TYPE_KEY, SSLUtil.getGlobalKeystoreType((String)KEYSTORE_TYPE_DEFAULT_VALUE));
        this.parseList(context.getString(EXCLUDE_PROTOCOLS, SSLUtil.getGlobalExcludeProtocols()), this.excludeProtocols);
        this.parseList(context.getString(INCLUDE_PROTOCOLS, SSLUtil.getGlobalIncludeProtocols()), this.includeProtocols);
        this.parseList(context.getString(EXCLUDE_CIPHER_SUITES, SSLUtil.getGlobalExcludeCipherSuites()), this.excludeCipherSuites);
        this.parseList(context.getString(INCLUDE_CIPHER_SUITES, SSLUtil.getGlobalIncludeCipherSuites()), this.includeCipherSuites);
        if (this.sslEnabled) {
            Objects.requireNonNull(this.keystore, "keystore must be specified when SSL is enabled");
            Objects.requireNonNull(this.keystorePassword, "keystore-password must be specified when SSL is enabled");
            try {
                KeyStore ks = KeyStore.getInstance(this.keystoreType);
                ks.load(new FileInputStream(this.keystore), this.keystorePassword.toCharArray());
            }
            catch (Exception ex) {
                throw new FlumeException("Source " + this.getName() + " configured with invalid keystore: " + this.keystore, (Throwable)ex);
            }
        }
    }

    private Optional<SSLContext> getSslContext() {
        if (this.sslEnabled) {
            try {
                KeyStore ks = KeyStore.getInstance(this.keystoreType);
                ks.load(new FileInputStream(this.keystore), this.keystorePassword.toCharArray());
                String algorithm = KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                kmf.init(ks, this.keystorePassword.toCharArray());
                SSLContext serverContext = SSLContext.getInstance("TLS");
                serverContext.init(kmf.getKeyManagers(), null, null);
                return Optional.of(serverContext);
            }
            catch (Exception e) {
                throw new Error("Failed to initialize the server-side SSLContext", e);
            }
        }
        return Optional.empty();
    }

    private Optional<SSLEngine> getSslEngine(boolean useClientMode) {
        return this.getSslContext().map(sslContext -> {
            SSLEngine sslEngine = sslContext.createSSLEngine();
            sslEngine.setUseClientMode(useClientMode);
            sslEngine.setEnabledProtocols(this.getFilteredProtocols(sslEngine.getEnabledProtocols()));
            sslEngine.setEnabledCipherSuites(this.getFilteredCipherSuites(sslEngine.getEnabledCipherSuites()));
            return sslEngine;
        });
    }

    protected Supplier<Optional<SSLContext>> getSslContextSupplier() {
        return this::getSslContext;
    }

    protected Supplier<Optional<SSLEngine>> getSslEngineSupplier(boolean useClientMode) {
        return () -> this.getSslEngine(useClientMode);
    }

    protected String[] getFilteredProtocols(SSLParameters sslParameters) {
        return this.getFilteredProtocols(sslParameters.getProtocols());
    }

    private String[] getFilteredProtocols(String[] enabledProtocols) {
        return (String[])Stream.of(enabledProtocols).filter(o -> this.includeProtocols.isEmpty() || this.includeProtocols.contains(o)).filter(o -> !this.excludeProtocols.contains(o)).toArray(String[]::new);
    }

    protected String[] getFilteredCipherSuites(SSLParameters sslParameters) {
        return this.getFilteredCipherSuites(sslParameters.getCipherSuites());
    }

    private String[] getFilteredCipherSuites(String[] enabledCipherSuites) {
        return (String[])Stream.of(enabledCipherSuites).filter(o -> this.includeCipherSuites.isEmpty() || this.includeCipherSuites.contains(o)).filter(o -> !this.excludeCipherSuites.contains(o)).toArray(String[]::new);
    }

    private void parseList(String value, Set<String> set) {
        if (Objects.nonNull(value)) {
            set.addAll(Arrays.asList(value.split(" ")));
        }
    }
}

