/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DataQualityResult;
import software.amazon.awssdk.services.glue.model.DataQualityResultIdsCopier;
import software.amazon.awssdk.services.glue.model.DataQualityResultsListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetDataQualityResultResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchGetDataQualityResultResponse> {
    private static final SdkField<List<DataQualityResult>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Results").getter(BatchGetDataQualityResultResponse.getter(BatchGetDataQualityResultResponse::results)).setter(BatchGetDataQualityResultResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataQualityResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESULTS_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultsNotFound").getter(BatchGetDataQualityResultResponse.getter(BatchGetDataQualityResultResponse::resultsNotFound)).setter(BatchGetDataQualityResultResponse.setter(Builder::resultsNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, RESULTS_NOT_FOUND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetDataQualityResultResponse.memberNameToFieldInitializer();
    private final List<DataQualityResult> results;
    private final List<String> resultsNotFound;

    private BatchGetDataQualityResultResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.resultsNotFound = builder.resultsNotFound;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public final List<DataQualityResult> results() {
        return this.results;
    }

    public final boolean hasResultsNotFound() {
        return this.resultsNotFound != null && !(this.resultsNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> resultsNotFound() {
        return this.resultsNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultsNotFound() ? this.resultsNotFound() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDataQualityResultResponse)) {
            return false;
        }
        BatchGetDataQualityResultResponse other = (BatchGetDataQualityResultResponse)((Object)obj);
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results()) && this.hasResultsNotFound() == other.hasResultsNotFound() && Objects.equals(this.resultsNotFound(), other.resultsNotFound());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetDataQualityResultResponse").add("Results", this.hasResults() ? this.results() : null).add("ResultsNotFound", this.hasResultsNotFound() ? this.resultsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "ResultsNotFound": {
                return Optional.ofNullable(clazz.cast(this.resultsNotFound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Results", RESULTS_FIELD);
        map.put("ResultsNotFound", RESULTS_NOT_FOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDataQualityResultResponse, T> g) {
        return obj -> g.apply((BatchGetDataQualityResultResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<DataQualityResult> results = DefaultSdkAutoConstructList.getInstance();
        private List<String> resultsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDataQualityResultResponse model) {
            super(model);
            this.results(model.results);
            this.resultsNotFound(model.resultsNotFound);
        }

        public final List<DataQualityResult.Builder> getResults() {
            List<DataQualityResult.Builder> result = DataQualityResultsListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<DataQualityResult.BuilderImpl> results) {
            this.results = DataQualityResultsListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<DataQualityResult> results) {
            this.results = DataQualityResultsListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(DataQualityResult ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<DataQualityResult.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (DataQualityResult)((DataQualityResult.Builder)DataQualityResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getResultsNotFound() {
            if (this.resultsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resultsNotFound;
        }

        public final void setResultsNotFound(Collection<String> resultsNotFound) {
            this.resultsNotFound = DataQualityResultIdsCopier.copy(resultsNotFound);
        }

        @Override
        public final Builder resultsNotFound(Collection<String> resultsNotFound) {
            this.resultsNotFound = DataQualityResultIdsCopier.copy(resultsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsNotFound(String ... resultsNotFound) {
            this.resultsNotFound(Arrays.asList(resultsNotFound));
            return this;
        }

        @Override
        public BatchGetDataQualityResultResponse build() {
            return new BatchGetDataQualityResultResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetDataQualityResultResponse> {
        public Builder results(Collection<DataQualityResult> var1);

        public Builder results(DataQualityResult ... var1);

        public Builder results(Consumer<DataQualityResult.Builder> ... var1);

        public Builder resultsNotFound(Collection<String> var1);

        public Builder resultsNotFound(String ... var1);
    }
}

