/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CompactionStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergCompactionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergCompactionConfiguration> {
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("strategy").getter(IcebergCompactionConfiguration.getter(IcebergCompactionConfiguration::strategyAsString)).setter(IcebergCompactionConfiguration.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategy").build()}).build();
    private static final SdkField<Integer> MIN_INPUT_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minInputFiles").getter(IcebergCompactionConfiguration.getter(IcebergCompactionConfiguration::minInputFiles)).setter(IcebergCompactionConfiguration.setter(Builder::minInputFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minInputFiles").build()}).build();
    private static final SdkField<Integer> DELETE_FILE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("deleteFileThreshold").getter(IcebergCompactionConfiguration.getter(IcebergCompactionConfiguration::deleteFileThreshold)).setter(IcebergCompactionConfiguration.setter(Builder::deleteFileThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteFileThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRATEGY_FIELD, MIN_INPUT_FILES_FIELD, DELETE_FILE_THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergCompactionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String strategy;
    private final Integer minInputFiles;
    private final Integer deleteFileThreshold;

    private IcebergCompactionConfiguration(BuilderImpl builder) {
        this.strategy = builder.strategy;
        this.minInputFiles = builder.minInputFiles;
        this.deleteFileThreshold = builder.deleteFileThreshold;
    }

    public final CompactionStrategy strategy() {
        return CompactionStrategy.fromValue(this.strategy);
    }

    public final String strategyAsString() {
        return this.strategy;
    }

    public final Integer minInputFiles() {
        return this.minInputFiles;
    }

    public final Integer deleteFileThreshold() {
        return this.deleteFileThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minInputFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteFileThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergCompactionConfiguration)) {
            return false;
        }
        IcebergCompactionConfiguration other = (IcebergCompactionConfiguration)obj;
        return Objects.equals(this.strategyAsString(), other.strategyAsString()) && Objects.equals(this.minInputFiles(), other.minInputFiles()) && Objects.equals(this.deleteFileThreshold(), other.deleteFileThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergCompactionConfiguration").add("Strategy", (Object)this.strategyAsString()).add("MinInputFiles", (Object)this.minInputFiles()).add("DeleteFileThreshold", (Object)this.deleteFileThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
            case "minInputFiles": {
                return Optional.ofNullable(clazz.cast(this.minInputFiles()));
            }
            case "deleteFileThreshold": {
                return Optional.ofNullable(clazz.cast(this.deleteFileThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("strategy", STRATEGY_FIELD);
        map.put("minInputFiles", MIN_INPUT_FILES_FIELD);
        map.put("deleteFileThreshold", DELETE_FILE_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergCompactionConfiguration, T> g) {
        return obj -> g.apply((IcebergCompactionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String strategy;
        private Integer minInputFiles;
        private Integer deleteFileThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergCompactionConfiguration model) {
            this.strategy(model.strategy);
            this.minInputFiles(model.minInputFiles);
            this.deleteFileThreshold(model.deleteFileThreshold);
        }

        public final String getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(CompactionStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final Integer getMinInputFiles() {
            return this.minInputFiles;
        }

        public final void setMinInputFiles(Integer minInputFiles) {
            this.minInputFiles = minInputFiles;
        }

        @Override
        public final Builder minInputFiles(Integer minInputFiles) {
            this.minInputFiles = minInputFiles;
            return this;
        }

        public final Integer getDeleteFileThreshold() {
            return this.deleteFileThreshold;
        }

        public final void setDeleteFileThreshold(Integer deleteFileThreshold) {
            this.deleteFileThreshold = deleteFileThreshold;
        }

        @Override
        public final Builder deleteFileThreshold(Integer deleteFileThreshold) {
            this.deleteFileThreshold = deleteFileThreshold;
            return this;
        }

        public IcebergCompactionConfiguration build() {
            return new IcebergCompactionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergCompactionConfiguration> {
        public Builder strategy(String var1);

        public Builder strategy(CompactionStrategy var1);

        public Builder minInputFiles(Integer var1);

        public Builder deleteFileThreshold(Integer var1);
    }
}

