/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;

@SdkInternalApi
@ThreadSafe
@Immutable
public class FloatStringConverter
implements StringConverter<Float>,
PrimitiveConverter<Float> {
    private FloatStringConverter() {
    }

    public static FloatStringConverter create() {
        return new FloatStringConverter();
    }

    @Override
    public EnhancedType<Float> type() {
        return EnhancedType.of(Float.class);
    }

    @Override
    public EnhancedType<Float> primitiveType() {
        return EnhancedType.of(Float.TYPE);
    }

    @Override
    public Float fromString(String string) {
        return Float.valueOf(string);
    }
}

