/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Field;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SourceTimestampMode;
import io.debezium.connector.sqlserver.SqlServerChangeTable;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDefaultValueConverter;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.data.Envelope;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.DatabaseSchema;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnection
extends JdbcConnection {
    @Deprecated
    public static final String SERVER_TIMEZONE_PROP_NAME = "server.timezone";
    public static final String INSTANCE_NAME = "instance";
    private static final String GET_DATABASE_NAME = "SELECT name FROM sys.databases WHERE name = ?";
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnection.class);
    private static final String STATEMENTS_PLACEHOLDER = "#";
    private static final String DATABASE_NAME_PLACEHOLDER = "#db";
    private static final String GET_MAX_LSN = "SELECT [#db].sys.fn_cdc_get_max_lsn()";
    private static final String GET_MAX_TRANSACTION_LSN = "SELECT MAX(start_lsn) FROM [#db].cdc.lsn_time_mapping WHERE tran_id <> 0x00";
    private static final String GET_NTH_TRANSACTION_LSN_FROM_BEGINNING = "SELECT MAX(start_lsn) FROM (SELECT TOP (?) start_lsn FROM [#db].cdc.lsn_time_mapping WHERE tran_id <> 0x00 ORDER BY start_lsn) as next_lsns";
    private static final String GET_NTH_TRANSACTION_LSN_FROM_LAST = "SELECT MAX(start_lsn) FROM (SELECT TOP (? + 1) start_lsn FROM [#db].cdc.lsn_time_mapping WHERE start_lsn >= ? AND tran_id <> 0x00 ORDER BY start_lsn) as next_lsns";
    private static final String GET_MIN_LSN = "SELECT [#db].sys.fn_cdc_get_min_lsn('#')";
    private static final String LOCK_TABLE = "SELECT * FROM [#] WITH (TABLOCKX)";
    private static final String INCREMENT_LSN = "SELECT [#db].sys.fn_cdc_increment_lsn(?)";
    private static final String GET_ALL_CHANGES_FOR_TABLE = "SELECT *# FROM [#db].cdc.[fn_cdc_get_all_changes_#](?, ?, N'all update old') order by [__$start_lsn] ASC, [__$seqval] ASC, [__$operation] ASC";
    private final String get_all_changes_for_table;
    protected static final String LSN_TIMESTAMP_SELECT_STATEMENT = "TODATETIMEOFFSET([#db].sys.fn_cdc_map_lsn_to_time([__$start_lsn]), DATEPART(TZOFFSET, SYSDATETIMEOFFSET()))";
    private static final String GET_CAPTURED_COLUMNS = "SELECT object_id, column_name FROM [#db].cdc.captured_columns ORDER BY object_id, column_id";
    private static final String GET_CHANGE_TABLES = "WITH ordered_change_tables AS (SELECT ROW_NUMBER() OVER (PARTITION BY ct.source_object_id, ct.start_lsn ORDER BY ct.create_date DESC) AS ct_sequence, ct.* FROM [#db].cdc.change_tables AS ct#) SELECT OBJECT_SCHEMA_NAME(source_object_id, DB_ID(?)), OBJECT_NAME(source_object_id, DB_ID(?)), capture_instance, object_id, start_lsn FROM ordered_change_tables WHERE ct_sequence = 1";
    private static final String GET_NEW_CHANGE_TABLES = "SELECT * FROM [#db].cdc.change_tables WHERE start_lsn BETWEEN ? AND ?";
    private static final String OPENING_QUOTING_CHARACTER = "[";
    private static final String CLOSING_QUOTING_CHARACTER = "]";
    private static final String URL_PATTERN = "jdbc:sqlserver://${" + JdbcConfiguration.HOSTNAME + "}:${" + JdbcConfiguration.PORT + "}";
    private final boolean multiPartitionMode;
    private final String getAllChangesForTable;
    private final int queryFetchSize;
    private final SqlServerDefaultValueConverter defaultValueConverter;
    private boolean optionRecompile;

    public SqlServerConnection(JdbcConfiguration config, SourceTimestampMode sourceTimestampMode, SqlServerValueConverters valueConverters, Supplier<ClassLoader> classLoaderSupplier, Set<Envelope.Operation> skippedOperations, boolean multiPartitionMode) {
        super(config, SqlServerConnection.createConnectionFactory(multiPartitionMode), classLoaderSupplier, OPENING_QUOTING_CHARACTER, CLOSING_QUOTING_CHARACTER);
        if (this.config().hasKey(SERVER_TIMEZONE_PROP_NAME)) {
            LOGGER.warn("The '{}' option is deprecated and is not taken into account", (Object)SERVER_TIMEZONE_PROP_NAME);
        }
        this.defaultValueConverter = new SqlServerDefaultValueConverter(() -> ((SqlServerConnection)this).connection(), valueConverters);
        this.queryFetchSize = this.config().getInteger(CommonConnectorConfig.QUERY_FETCH_SIZE);
        if (!skippedOperations.isEmpty()) {
            HashSet skippedOps = new HashSet();
            StringBuilder getAllChangesForTableStatement = new StringBuilder("SELECT *# FROM [#db].cdc.[fn_cdc_get_all_changes_#](?, ?, N'all update old') WHERE __$operation NOT IN (");
            skippedOperations.forEach(operation -> {
                switch (operation) {
                    case CREATE: {
                        skippedOps.add("2");
                        break;
                    }
                    case UPDATE: {
                        skippedOps.add("3");
                        skippedOps.add("4");
                        break;
                    }
                    case DELETE: {
                        skippedOps.add("1");
                    }
                }
            });
            getAllChangesForTableStatement.append(String.join((CharSequence)",", skippedOps));
            getAllChangesForTableStatement.append(") order by [__$start_lsn] ASC, [__$seqval] ASC, [__$operation] ASC");
            this.get_all_changes_for_table = getAllChangesForTableStatement.toString();
        } else {
            this.get_all_changes_for_table = GET_ALL_CHANGES_FOR_TABLE;
        }
        this.getAllChangesForTable = this.get_all_changes_for_table.replaceFirst(STATEMENTS_PLACEHOLDER, Matcher.quoteReplacement(sourceTimestampMode.lsnTimestampSelectStatement()));
        this.multiPartitionMode = multiPartitionMode;
        this.optionRecompile = false;
    }

    public SqlServerConnection(JdbcConfiguration config, SourceTimestampMode sourceTimestampMode, SqlServerValueConverters valueConverters, Supplier<ClassLoader> classLoaderSupplier, Set<Envelope.Operation> skippedOperations, boolean multiPartitionMode, boolean optionRecompile) {
        this(config, sourceTimestampMode, valueConverters, classLoaderSupplier, skippedOperations, multiPartitionMode);
        this.optionRecompile = optionRecompile;
    }

    private static String createUrlPattern(boolean multiPartitionMode) {
        String pattern = URL_PATTERN;
        if (!multiPartitionMode) {
            pattern = pattern + ";databaseName=${" + JdbcConfiguration.DATABASE + "}";
        }
        return pattern;
    }

    private static JdbcConnection.ConnectionFactory createConnectionFactory(boolean multiPartitionMode) {
        return JdbcConnection.patternBasedFactory((String)SqlServerConnection.createUrlPattern(multiPartitionMode), (String)SQLServerDriver.class.getName(), (ClassLoader)SqlServerConnection.class.getClassLoader(), (Field[])new Field[]{JdbcConfiguration.PORT.withDefault(SqlServerConnectorConfig.PORT.defaultValueAsString())});
    }

    public String connectionString() {
        return this.connectionString(SqlServerConnection.createUrlPattern(this.multiPartitionMode));
    }

    public synchronized Connection connection(boolean executeOnConnect) throws SQLException {
        boolean connected = this.isConnected();
        Connection connection = super.connection(executeOnConnect);
        if (!connected) {
            connection.setAutoCommit(false);
        }
        return connection;
    }

    public Lsn getMaxLsn(String databaseName) throws SQLException {
        return (Lsn)this.queryAndMap(this.replaceDatabaseNamePlaceholder(GET_MAX_LSN, databaseName), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Current maximum lsn is {}", (Object)ret);
            return ret;
        }, "Maximum LSN query must return exactly one value"));
    }

    public Lsn getNthTransactionLsnFromBeginning(String databaseName, int maxOffset) throws SQLException {
        return (Lsn)this.prepareQueryAndMap(this.replaceDatabaseNamePlaceholder(GET_NTH_TRANSACTION_LSN_FROM_BEGINNING, databaseName), statement -> statement.setInt(1, maxOffset), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Nth lsn from beginning is {}", (Object)ret);
            return ret;
        }, "Nth LSN query must return exactly one value"));
    }

    public Lsn getNthTransactionLsnFromLast(String databaseName, Lsn lastLsn, int maxOffset) throws SQLException {
        return (Lsn)this.prepareQueryAndMap(this.replaceDatabaseNamePlaceholder(GET_NTH_TRANSACTION_LSN_FROM_LAST, databaseName), statement -> {
            statement.setInt(1, maxOffset);
            statement.setBytes(2, lastLsn.getBinary());
        }, this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Nth lsn from last is {}", (Object)ret);
            return ret;
        }, "Nth LSN query must return exactly one value"));
    }

    public Lsn getMaxTransactionLsn(String databaseName) throws SQLException {
        return (Lsn)this.queryAndMap(this.replaceDatabaseNamePlaceholder(GET_MAX_TRANSACTION_LSN, databaseName), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Max transaction lsn is {}", (Object)ret);
            return ret;
        }, "Max transaction LSN query must return exactly one value"));
    }

    public Lsn getMinLsn(String databaseName, String changeTableName) throws SQLException {
        String query = this.replaceDatabaseNamePlaceholder(GET_MIN_LSN, databaseName).replace(STATEMENTS_PLACEHOLDER, changeTableName);
        return (Lsn)this.queryAndMap(query, this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Current minimum lsn is {}", (Object)ret);
            return ret;
        }, "Minimum LSN query must return exactly one value"));
    }

    public void getChangesForTables(String databaseName, SqlServerChangeTable[] changeTables, Lsn intervalFromLsn, Lsn intervalToLsn, JdbcConnection.BlockingMultiResultSetConsumer consumer) throws SQLException, InterruptedException {
        String[] queries = new String[changeTables.length];
        JdbcConnection.StatementPreparer[] preparers = new JdbcConnection.StatementPreparer[changeTables.length];
        int idx = 0;
        for (SqlServerChangeTable changeTable : changeTables) {
            String query;
            queries[idx] = query = this.replaceDatabaseNamePlaceholder(this.getAllChangesForTable, databaseName).replace(STATEMENTS_PLACEHOLDER, changeTable.getCaptureInstance());
            Lsn fromLsn = this.getFromLsn(databaseName, changeTable, intervalFromLsn);
            LOGGER.trace("Getting changes for table {} in range[{}, {}]", new Object[]{changeTable, fromLsn, intervalToLsn});
            preparers[idx] = statement -> {
                if (this.queryFetchSize > 0) {
                    statement.setFetchSize(this.queryFetchSize);
                }
                statement.setBytes(1, fromLsn.getBinary());
                statement.setBytes(2, intervalToLsn.getBinary());
            };
            ++idx;
        }
        this.prepareQuery(queries, preparers, consumer);
    }

    private Lsn getFromLsn(String databaseName, SqlServerChangeTable changeTable, Lsn intervalFromLsn) throws SQLException {
        Lsn fromLsn = changeTable.getStartLsn().compareTo(intervalFromLsn) > 0 ? changeTable.getStartLsn() : intervalFromLsn;
        return fromLsn.getBinary() != null ? fromLsn : this.getMinLsn(databaseName, changeTable.getCaptureInstance());
    }

    public Lsn incrementLsn(String databaseName, Lsn lsn) throws SQLException {
        return (Lsn)this.prepareQueryAndMap(this.replaceDatabaseNamePlaceholder(INCREMENT_LSN, databaseName), statement -> statement.setBytes(1, lsn.getBinary()), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Increasing lsn from {} to {}", (Object)lsn, (Object)ret);
            return ret;
        }, "Increment LSN query must return exactly one value"));
    }

    public void lockTable(TableId tableId) throws SQLException {
        String lockTableStmt = LOCK_TABLE.replace(STATEMENTS_PLACEHOLDER, tableId.table());
        this.execute(new String[]{lockTableStmt});
    }

    private String cdcNameForTable(TableId tableId) {
        return tableId.schema() + '_' + tableId.table();
    }

    public List<SqlServerChangeTable> getChangeTables(String databaseName) throws SQLException {
        return this.getChangeTables(databaseName, Lsn.NULL);
    }

    public List<SqlServerChangeTable> getChangeTables(String databaseName, Lsn toLsn) throws SQLException {
        Map columns = (Map)this.queryAndMap(this.replaceDatabaseNamePlaceholder(GET_CAPTURED_COLUMNS, databaseName), rs -> {
            HashMap result = new HashMap();
            while (rs.next()) {
                int changeTableObjectId = rs.getInt(1);
                if (!result.containsKey(changeTableObjectId)) {
                    result.put(changeTableObjectId, new LinkedList());
                }
                ((List)result.get(changeTableObjectId)).add(rs.getString(2));
            }
            return result;
        });
        JdbcConnection.ResultSetMapper mapper = rs -> {
            ArrayList<SqlServerChangeTable> changeTables = new ArrayList<SqlServerChangeTable>();
            while (rs.next()) {
                int changeTableObjectId = rs.getInt(4);
                changeTables.add(new SqlServerChangeTable(new TableId(databaseName, rs.getString(1), rs.getString(2)), rs.getString(3), changeTableObjectId, Lsn.valueOf(rs.getBytes(5)), (List)columns.get(changeTableObjectId)));
            }
            return changeTables;
        };
        String query = this.replaceDatabaseNamePlaceholder(GET_CHANGE_TABLES, databaseName);
        if (toLsn.isAvailable()) {
            return (List)this.prepareQueryAndMap(query.replace(STATEMENTS_PLACEHOLDER, " WHERE ct.start_lsn <= ?"), ps -> {
                ps.setBytes(1, toLsn.getBinary());
                ps.setString(2, databaseName);
                ps.setString(3, databaseName);
            }, mapper);
        }
        return (List)this.prepareQueryAndMap(query.replace(STATEMENTS_PLACEHOLDER, ""), ps -> {
            ps.setString(1, databaseName);
            ps.setString(2, databaseName);
        }, mapper);
    }

    public List<SqlServerChangeTable> getNewChangeTables(String databaseName, Lsn fromLsn, Lsn toLsn) throws SQLException {
        String query = this.replaceDatabaseNamePlaceholder(GET_NEW_CHANGE_TABLES, databaseName);
        return (List)this.prepareQueryAndMap(query, ps -> {
            ps.setBytes(1, fromLsn.getBinary());
            ps.setBytes(2, toLsn.getBinary());
        }, rs -> {
            ArrayList<SqlServerChangeTable> changeTables = new ArrayList<SqlServerChangeTable>();
            while (rs.next()) {
                changeTables.add(new SqlServerChangeTable(rs.getString(4), rs.getInt(1), Lsn.valueOf(rs.getBytes(5))));
            }
            return changeTables;
        });
    }

    public Table getTableSchemaFromTable(String databaseName, SqlServerChangeTable changeTable) throws SQLException {
        DatabaseMetaData metadata = this.connection().getMetaData();
        ArrayList columns = new ArrayList();
        try (ResultSet rs = metadata.getColumns(databaseName, changeTable.getSourceTableId().schema(), changeTable.getSourceTableId().table(), null);){
            while (rs.next()) {
                this.readTableColumn(rs, changeTable.getSourceTableId(), null).ifPresent(ce -> {
                    if (changeTable.getCapturedColumns().contains(ce.name())) {
                        columns.add(ce.create());
                    }
                });
            }
        }
        List pkColumnNames = this.readPrimaryKeyOrUniqueIndexNames(metadata, changeTable.getSourceTableId()).stream().filter(column -> changeTable.getCapturedColumns().contains(column)).collect(Collectors.toList());
        Collections.sort(columns);
        return Table.editor().tableId(changeTable.getSourceTableId()).addColumns(columns).setPrimaryKeyNames(pkColumnNames).create();
    }

    public String getNameOfChangeTable(String captureName) {
        return captureName + "_CT";
    }

    public String retrieveRealDatabaseName(String databaseName) {
        try {
            return (String)this.prepareQueryAndMap(GET_DATABASE_NAME, ps -> ps.setString(1, databaseName), this.singleResultMapper(rs -> rs.getString(1), "Could not retrieve exactly one database name"));
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't obtain database name", e);
        }
    }

    protected boolean isTableUniqueIndexIncluded(String indexName, String columnName) {
        return indexName != null;
    }

    public <T extends DatabaseSchema<TableId>> Object getColumnValue(ResultSet rs, int columnIndex, Column column, Table table, T schema) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnType = metaData.getColumnType(columnIndex);
        if (columnType == 92) {
            return rs.getTimestamp(columnIndex);
        }
        return super.getColumnValue(rs, columnIndex, column, table, schema);
    }

    public String buildSelectWithRowLimits(TableId tableId, int limit, String projection, Optional<String> condition, String orderBy) {
        StringBuilder sql = new StringBuilder("SELECT TOP ");
        sql.append(limit).append(' ').append(projection).append(" FROM ");
        sql.append(this.quotedTableIdString(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        sql.append(" ORDER BY ").append(orderBy);
        if (this.optionRecompile) {
            sql.append(" OPTION(RECOMPILE)");
        }
        return sql.toString();
    }

    public String quotedTableIdString(TableId tableId) {
        return OPENING_QUOTING_CHARACTER + tableId.catalog() + "].[" + tableId.schema() + "].[" + tableId.table() + CLOSING_QUOTING_CHARACTER;
    }

    private String replaceDatabaseNamePlaceholder(String sql, String databaseName) {
        return sql.replace(DATABASE_NAME_PLACEHOLDER, databaseName);
    }

    public SqlServerDefaultValueConverter getDefaultValueConverter() {
        return this.defaultValueConverter;
    }

    public static class CdcEnabledTable {
        private final String tableId;
        private final String captureName;
        private final Lsn fromLsn;

        private CdcEnabledTable(String tableId, String captureName, Lsn fromLsn) {
            this.tableId = tableId;
            this.captureName = captureName;
            this.fromLsn = fromLsn;
        }

        public String getTableId() {
            return this.tableId;
        }

        public String getCaptureName() {
            return this.captureName;
        }

        public Lsn getFromLsn() {
            return this.fromLsn;
        }
    }
}

