/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.Strings;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

public class RestMultiGetAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestMultiGetAction.class);
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in multi get requests is deprecated.";
    private final boolean allowExplicitIndex;

    public RestMultiGetAction(Settings settings) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_mget"), new RestHandler.Route(RestRequest.Method.POST, "/_mget"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mget"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mget"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/_mget"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}/_mget")));
    }

    @Override
    public String getName() {
        return "document_mget_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.param("type") != null) {
            deprecationLogger.deprecate("mget_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        multiGetRequest.refresh(request.paramAsBoolean("refresh", multiGetRequest.refresh()));
        multiGetRequest.preference(request.param("preference"));
        multiGetRequest.realtime(request.paramAsBoolean("realtime", multiGetRequest.realtime()));
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("The parameter [fields] is no longer supported, please use [stored_fields] to retrieve stored fields or _source filtering if the field is not stored");
        }
        String[] sFields = null;
        String sField = request.param("stored_fields");
        if (sField != null) {
            sFields = Strings.splitStringByCommaToArray(sField);
        }
        FetchSourceContext defaultFetchSource = FetchSourceContext.parseFromRestRequest(request);
        try (XContentParser parser = request.contentOrSourceParamParser();){
            multiGetRequest.add(request.param("index"), request.param("type"), sFields, defaultFetchSource, request.param("routing"), parser, this.allowExplicitIndex);
        }
        for (MultiGetRequest.Item item : multiGetRequest.getItems()) {
            if (item.type() == null) continue;
            deprecationLogger.deprecate("multi_get_types_removal", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            break;
        }
        return channel -> client.multiGet(multiGetRequest, new RestToXContentListener<MultiGetResponse>((RestChannel)channel));
    }
}

