/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.BatchRead;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Replica;
import java.util.ArrayList;
import java.util.List;

public final class BatchNode {
    public final Node node;
    public int[] offsets;
    public int offsetsSize;

    public static List<BatchNode> generateList(Cluster cluster, BatchPolicy policy, Key[] keys) {
        Node[] nodes = cluster.validateNodes();
        int keysPerNode = keys.length / nodes.length;
        if ((keysPerNode += keysPerNode >>> 2) < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        for (int i = 0; i < keys.length; ++i) {
            Node node = Partition.getNodeBatchRead(cluster, keys[i], replica, replicaSC, 0, 0);
            BatchNode batchNode = BatchNode.findBatchNode(batchNodes, node);
            if (batchNode == null) {
                batchNodes.add(new BatchNode(node, keysPerNode, i));
                continue;
            }
            batchNode.addKey(i);
        }
        return batchNodes;
    }

    public static List<BatchNode> generateList(Cluster cluster, BatchPolicy policy, Key[] keys, int sequenceAP, int sequenceSC, BatchNode batchSeed) {
        Node[] nodes = cluster.validateNodes();
        int keysPerNode = batchSeed.offsetsSize / nodes.length;
        if ((keysPerNode += keysPerNode >>> 2) < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        for (int i = 0; i < batchSeed.offsetsSize; ++i) {
            int offset = batchSeed.offsets[i];
            Node node = Partition.getNodeBatchRead(cluster, keys[offset], replica, replicaSC, sequenceAP, sequenceSC);
            BatchNode batchNode = BatchNode.findBatchNode(batchNodes, node);
            if (batchNode == null) {
                batchNodes.add(new BatchNode(node, keysPerNode, offset));
                continue;
            }
            batchNode.addKey(offset);
        }
        return batchNodes;
    }

    public static List<BatchNode> generateList(Cluster cluster, BatchPolicy policy, List<BatchRead> records) {
        Node[] nodes = cluster.validateNodes();
        int max = records.size();
        int keysPerNode = max / nodes.length;
        if ((keysPerNode += keysPerNode >>> 2) < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        for (int i = 0; i < max; ++i) {
            Node node = Partition.getNodeBatchRead(cluster, records.get((int)i).key, replica, replicaSC, 0, 0);
            BatchNode batchNode = BatchNode.findBatchNode(batchNodes, node);
            if (batchNode == null) {
                batchNodes.add(new BatchNode(node, keysPerNode, i));
                continue;
            }
            batchNode.addKey(i);
        }
        return batchNodes;
    }

    public static List<BatchNode> generateList(Cluster cluster, BatchPolicy policy, List<BatchRead> records, int sequenceAP, int sequenceSC, BatchNode batchSeed) {
        Node[] nodes = cluster.validateNodes();
        int keysPerNode = batchSeed.offsetsSize / nodes.length;
        if ((keysPerNode += keysPerNode >>> 2) < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        for (int i = 0; i < batchSeed.offsetsSize; ++i) {
            int offset = batchSeed.offsets[i];
            Node node = Partition.getNodeBatchRead(cluster, records.get((int)offset).key, replica, replicaSC, sequenceAP, sequenceSC);
            BatchNode batchNode = BatchNode.findBatchNode(batchNodes, node);
            if (batchNode == null) {
                batchNodes.add(new BatchNode(node, keysPerNode, offset));
                continue;
            }
            batchNode.addKey(offset);
        }
        return batchNodes;
    }

    private static BatchNode findBatchNode(List<BatchNode> nodes, Node node) {
        for (BatchNode batchNode : nodes) {
            if (batchNode.node != node) continue;
            return batchNode;
        }
        return null;
    }

    public BatchNode(Node node, int capacity, int offset) {
        this.node = node;
        this.offsets = new int[capacity];
        this.offsets[0] = offset;
        this.offsetsSize = 1;
    }

    public void addKey(int offset) {
        if (this.offsetsSize >= this.offsets.length) {
            int[] copy = new int[this.offsetsSize * 2];
            System.arraycopy(this.offsets, 0, copy, 0, this.offsetsSize);
            this.offsets = copy;
        }
        this.offsets[this.offsetsSize++] = offset;
    }
}

