/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.ScanPolicy;

public final class ScanCommand
extends MultiCommand {
    private final ScanPolicy scanPolicy;
    private final String setName;
    private final String[] binNames;
    private final ScanCallback callback;
    private final long taskId;

    public ScanCommand(Cluster cluster, Node node, ScanPolicy scanPolicy, String namespace, String setName, String[] binNames, ScanCallback callback, long taskId, long clusterKey, boolean first) {
        super(cluster, (Policy)scanPolicy, node, namespace, clusterKey, first);
        this.scanPolicy = scanPolicy;
        this.setName = setName;
        this.binNames = binNames;
        this.callback = callback;
        this.taskId = taskId;
    }

    @Override
    public void execute() {
        this.executeAndValidate();
    }

    @Override
    protected void writeBuffer() {
        this.setScan(this.scanPolicy, this.namespace, this.setName, this.binNames, this.taskId, null);
    }

    @Override
    protected void parseRow(Key key) {
        Record record = this.parseRecord();
        if (!this.valid) {
            throw new AerospikeException.ScanTerminated();
        }
        this.callback.scanCallback(key, record);
    }
}

