/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.query.PartitionTracker;

public final class ScanPartitionCommand
extends MultiCommand {
    private final ScanPolicy scanPolicy;
    private final String setName;
    private final String[] binNames;
    private final ScanCallback callback;
    private final long taskId;
    private final PartitionTracker tracker;
    private final PartitionTracker.NodePartitions nodePartitions;

    public ScanPartitionCommand(Cluster cluster, ScanPolicy scanPolicy, String namespace, String setName, String[] binNames, ScanCallback callback, long taskId, PartitionTracker tracker, PartitionTracker.NodePartitions nodePartitions) {
        super(cluster, (Policy)scanPolicy, nodePartitions.node, namespace, tracker.socketTimeout, tracker.totalTimeout);
        this.scanPolicy = scanPolicy;
        this.setName = setName;
        this.binNames = binNames;
        this.callback = callback;
        this.taskId = taskId;
        this.tracker = tracker;
        this.nodePartitions = nodePartitions;
    }

    @Override
    public void execute() {
        block2: {
            try {
                this.executeCommand();
            }
            catch (AerospikeException ae) {
                if (this.tracker.shouldRetry(ae)) break block2;
                throw ae;
            }
        }
    }

    @Override
    protected void writeBuffer() {
        this.setScan(this.scanPolicy, this.namespace, this.setName, this.binNames, this.taskId, this.nodePartitions);
    }

    @Override
    protected void parseRow(Key key) {
        if ((this.info3 & 4) != 0) {
            if (this.resultCode == 0) {
                this.tracker.partitionDone(this.nodePartitions, this.generation);
            }
            return;
        }
        this.tracker.setDigest(this.nodePartitions, key);
        if (this.resultCode != 0) {
            throw new AerospikeException(this.resultCode);
        }
        Record record = this.parseRecord();
        if (!this.valid) {
            throw new AerospikeException.ScanTerminated();
        }
        this.callback.scanCallback(key, record);
    }
}

