/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.Key;
import com.aerospike.client.cluster.Partition;
import java.io.Serializable;

public final class PartitionFilter
implements Serializable {
    private static final long serialVersionUID = 2L;
    final int begin;
    final int count;
    final byte[] digest;

    public static PartitionFilter id(int id) {
        return new PartitionFilter(id, 1);
    }

    public static PartitionFilter after(Key key) {
        return new PartitionFilter(key.digest);
    }

    public static PartitionFilter range(int begin, int count) {
        return new PartitionFilter(begin, count);
    }

    private PartitionFilter(int begin, int count) {
        this.begin = begin;
        this.count = count;
        this.digest = null;
    }

    private PartitionFilter(byte[] digest) {
        this.begin = Partition.getPartitionId(digest);
        this.count = 1;
        this.digest = digest;
    }
}

