/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import alluxio.collections.FieldIndex;
import alluxio.collections.IndexDefinition;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class UniqueFieldIndex<T, V>
implements FieldIndex<T, V> {
    private final IndexDefinition<T, V> mIndexDefinition;
    private final ConcurrentHashMap<V, T> mIndexMap = new ConcurrentHashMap(8, 0.95f, 8);

    public UniqueFieldIndex(IndexDefinition<T, V> indexDefinition) {
        this.mIndexDefinition = indexDefinition;
    }

    @Override
    public boolean add(T object) {
        V fieldValue = this.mIndexDefinition.getFieldValue(object);
        T previousObject = this.mIndexMap.putIfAbsent(fieldValue, object);
        return previousObject == null || previousObject == object;
    }

    @Override
    public boolean remove(T object) {
        V fieldValue = this.mIndexDefinition.getFieldValue(object);
        return this.mIndexMap.remove(fieldValue, object);
    }

    @Override
    public void clear() {
        this.mIndexMap.clear();
    }

    @Override
    public boolean containsField(V fieldValue) {
        return this.mIndexMap.containsKey(fieldValue);
    }

    @Override
    public boolean containsObject(T object) {
        V fieldValue = this.mIndexDefinition.getFieldValue(object);
        T res = this.mIndexMap.get(fieldValue);
        if (res == null) {
            return false;
        }
        return res == object;
    }

    @Override
    public Set<T> getByField(V value) {
        T res = this.mIndexMap.get(value);
        if (res != null) {
            return Collections.singleton(res);
        }
        return Collections.emptySet();
    }

    @Override
    public T getFirst(V value) {
        return this.mIndexMap.get(value);
    }

    @Override
    public Iterator<T> iterator() {
        return this.mIndexMap.values().iterator();
    }

    @Override
    public int size() {
        return this.mIndexMap.size();
    }
}

