/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf.path;

import alluxio.collections.Pair;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Stream;

public final class TrieNode<V> {
    private final Map<String, TrieNode<V>> mChildren = new HashMap<String, TrieNode<V>>();
    private boolean mIsTerminal = false;
    private V mValue;

    public void setValue(V value) {
        this.mValue = value;
    }

    public V getValue() {
        return this.mValue;
    }

    public TrieNode<V> insert(String path) {
        TrieNode<V> current = this;
        for (String component : path.split("/")) {
            if (!current.mChildren.containsKey(component)) {
                current.mChildren.put(component, new TrieNode<V>());
            }
            current = current.mChildren.get(component);
        }
        current.mIsTerminal = true;
        return current;
    }

    public Optional<TrieNode<V>> getClosestTerminal(String path) {
        TrieNode<V> current = this;
        TrieNode<V> result = current.isTerminal() ? current : null;
        for (String nxt : path.split("/")) {
            if (!current.mChildren.containsKey(nxt)) break;
            current = current.mChildren.get(nxt);
            if (!current.mIsTerminal) continue;
            result = current;
        }
        return Optional.ofNullable(result);
    }

    public List<TrieNode<V>> search(String path) {
        ArrayList<TrieNode<V>> terminal = new ArrayList<TrieNode<V>>();
        TrieNode<V> current = this;
        if (current.mIsTerminal) {
            terminal.add(current);
        }
        for (String component : path.split("/")) {
            if (!current.mChildren.containsKey(component)) break;
            current = current.mChildren.get(component);
            if (!current.mIsTerminal) continue;
            terminal.add(current);
        }
        return terminal;
    }

    public Optional<TrieNode<V>> searchExact(String path) {
        return this.getNode(path).filter(TrieNode::isTerminal);
    }

    public boolean hasTerminal(String path, boolean includeChildren) {
        TrieNode<V> current = this;
        if (current.mIsTerminal) {
            return true;
        }
        for (String component : path.split("/")) {
            TrieNode<V> child = current.mChildren.get(component);
            if (child != null) {
                current = child;
                if (!current.mIsTerminal) continue;
                return true;
            }
            return false;
        }
        return includeChildren;
    }

    public TrieNode<V> deleteIf(String path, Function<TrieNode<V>, Boolean> predicate) {
        Stack<Pair<TrieNode, String>> parents = new Stack<Pair<TrieNode, String>>();
        TrieNode current = this;
        for (String component : path.split("/")) {
            if (!current.mChildren.containsKey(component)) {
                return null;
            }
            parents.push(new Pair<TrieNode, String>(current, component));
            current = current.mChildren.get(component);
        }
        if (!current.mIsTerminal) {
            return null;
        }
        if (!predicate.apply(current).booleanValue()) {
            return null;
        }
        TrieNode nodeToDelete = current;
        current.mIsTerminal = false;
        while (current.mChildren.isEmpty() && !current.mIsTerminal && !parents.empty()) {
            Pair parent = (Pair)parents.pop();
            current = (TrieNode)parent.getFirst();
            current.mChildren.remove(parent.getSecond());
        }
        return nodeToDelete;
    }

    public Iterator<TrieNode<V>> getCommonRoots() {
        if (this.mIsTerminal) {
            return Collections.singletonList(this).iterator();
        }
        return Iterators.concat(this.mChildren.values().stream().map(TrieNode::getCommonRoots).iterator());
    }

    public Stream<TrieNode<V>> getLeafChildren(String path) {
        return this.getNode(path).map(current -> current.getChildrenInternal().filter(TrieNode::isTerminal)).orElseGet(Stream::empty);
    }

    private Optional<TrieNode<V>> getNode(String path) {
        int i;
        TrieNode<V> current = this;
        String[] components = path.split("/");
        for (i = 0; i < components.length && current.mChildren.containsKey(components[i]); ++i) {
            current = current.mChildren.get(components[i]);
        }
        if (i != components.length) {
            return Optional.empty();
        }
        return Optional.of(current);
    }

    private boolean isTerminal() {
        return this.mIsTerminal;
    }

    private Stream<TrieNode<V>> getChildrenInternal() {
        return Stream.concat(Stream.of(this), this.mChildren.values().stream().flatMap(TrieNode::getChildrenInternal));
    }

    public void clear() {
        for (TrieNode<V> child : this.mChildren.values()) {
            child.clear();
        }
        this.mChildren.clear();
    }
}

