/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.grpc.BlockWorkerGrpc;
import alluxio.grpc.Chunk;
import alluxio.grpc.DataMessage;
import alluxio.grpc.DataMessageMarshaller;
import alluxio.grpc.GrpcSerializationUtils;
import alluxio.grpc.ReadResponse;
import alluxio.grpc.ReadableDataBuffer;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.NettyDataBuffer;
import alluxio.util.proto.ProtoUtils;
import com.google.common.base.Preconditions;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.ReadableBuffers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ReadResponseMarshaller
extends DataMessageMarshaller<ReadResponse> {
    public ReadResponseMarshaller() {
        super(BlockWorkerGrpc.getReadBlockMethod().getResponseMarshaller());
    }

    @Override
    protected ByteBuf[] serialize(ReadResponse message) throws IOException {
        Object chunkBuffer = this.pollBuffer(message);
        if (chunkBuffer == null) {
            if (!message.hasChunk() || !message.getChunk().hasData()) {
                return new ByteBuf[0];
            }
            chunkBuffer = new NettyDataBuffer(Unpooled.wrappedBuffer((ByteBuffer)message.getChunk().getData().asReadOnlyByteBuffer()));
        }
        int size = message.getSerializedSize() - chunkBuffer.readableBytes();
        byte[] header = new byte[size];
        CodedOutputStream stream = CodedOutputStream.newInstance((byte[])header);
        stream.writeTag(1, 2);
        stream.writeUInt32NoTag(message.getChunk().getSerializedSize());
        stream.writeTag(1, 2);
        stream.writeUInt32NoTag(chunkBuffer.readableBytes());
        return new ByteBuf[]{Unpooled.wrappedBuffer((byte[])header), (ByteBuf)chunkBuffer.getNettyOutput()};
    }

    @Override
    protected ReadResponse deserialize(ReadableBuffer buffer) throws IOException {
        if (buffer.readableBytes() == 0) {
            return ReadResponse.getDefaultInstance();
        }
        try (InputStream is = ReadableBuffers.openStream((ReadableBuffer)buffer, (boolean)false);){
            Preconditions.checkState((ProtoUtils.readRawVarint32(is) == GrpcSerializationUtils.makeTag(1, 2) ? 1 : 0) != 0);
            int messageSize = ProtoUtils.readRawVarint32(is);
            Preconditions.checkState((messageSize == buffer.readableBytes() ? 1 : 0) != 0);
            Preconditions.checkState((ProtoUtils.readRawVarint32(is) == GrpcSerializationUtils.makeTag(1, 2) ? 1 : 0) != 0);
            int chunkSize = ProtoUtils.readRawVarint32(is);
            Preconditions.checkState((chunkSize == buffer.readableBytes() ? 1 : 0) != 0);
            ReadResponse response = ReadResponse.newBuilder().build();
            this.offerBuffer(new ReadableDataBuffer(buffer), response);
            ReadResponse readResponse = response;
            return readResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadResponse combineData(@Nullable DataMessage<ReadResponse, DataBuffer> message) {
        if (message == null) {
            return null;
        }
        DataBuffer buffer = message.getBuffer();
        if (buffer == null) {
            return message.getMessage();
        }
        try {
            byte[] bytes = new byte[buffer.readableBytes()];
            buffer.readBytes(bytes, 0, bytes.length);
            ReadResponse readResponse = message.getMessage().toBuilder().setChunk(Chunk.newBuilder().setData(UnsafeByteOperations.unsafeWrap((byte[])bytes)).build()).build();
            return readResponse;
        }
        finally {
            message.getBuffer().release();
        }
    }
}

