/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class JobDescription {
    private final String mPath;
    private final String mType;

    private JobDescription(String type, String path) {
        this.mPath = path;
        this.mType = type;
    }

    public String getType() {
        return this.mType;
    }

    public String getPath() {
        return this.mPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDescription that = (JobDescription)o;
        return Objects.equal((Object)this.mPath, (Object)that.mPath) && Objects.equal((Object)this.mType, (Object)that.mType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mType, this.mPath});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Path", (Object)this.mPath).add("Type", (Object)this.mType).toString();
    }

    public static JobDescription from(alluxio.grpc.JobDescription jobDescription) {
        return new JobDescription(jobDescription.getType(), jobDescription.getPath());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String mPath;
        private String mType;

        private Builder() {
        }

        public Builder setPath(String path) {
            this.mPath = path;
            return this;
        }

        public Builder setType(String type) {
            this.mType = type;
            return this;
        }

        public JobDescription build() {
            return new JobDescription(this.mType, this.mPath);
        }
    }
}

