/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ChannelIdInjector
implements ClientInterceptor {
    public static final Metadata.Key<UUID> S_CLIENT_ID_KEY = Metadata.Key.of((String)"channel-id", (Metadata.AsciiMarshaller)new Metadata.AsciiMarshaller<UUID>(){

        public String toAsciiString(UUID value) {
            return value.toString();
        }

        public UUID parseAsciiString(String serialized) {
            return UUID.fromString(serialized);
        }
    });
    private final UUID mChannelId;

    public ChannelIdInjector(UUID channelId) {
        this.mChannelId = channelId;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(S_CLIENT_ID_KEY, (Object)ChannelIdInjector.this.mChannelId);
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onHeaders(Metadata headers) {
                        super.onHeaders(headers);
                    }
                }, headers);
            }
        };
    }
}

